library(shinytest2)

test_that("{Test ShinyWizard} recording: source", {
  # App Dir
  appDir <- paste0(base::system.file("", package = "ShinyWizard"), "inst/source")
  # Skip on app_dir temporary folder eg. check rather than test()
  testthat::skip_if(dir.exists(appDir) == FALSE)
  # Test
  app <- AppDriver$new(app_dir = appDir, name = "source", height = 731, width = 1139)
  # ->
  app$click("NavBar-go_1_2")
  app$set_inputs(`tab2-AppTitleInput` = "Shiny Wizard2")
  app$set_inputs(`tab2-AppSubTitleInput` = "Design, build, deploy!2")
  app$set_inputs(`tab2-LogoFilePathInput` = "img/logo2.png")
  app$set_inputs(`tab2-FooterTextInput` = "2")
  app$set_inputs(`tab2-shinytheme-selector` = "cyborg")
  app$click("NavBar-go_2_3")
  app$click("tab3-newTab")
  app$set_inputs(`tab3-ui1` = "# --- Navigation ---\n# TabName: Tab0\n# TabIcon: file\n# --- Next/Prev buttons\n# ShowButtons: TRUE\n# ButtonsAlignment: center\n# --- Info ---\n# InfoTitle: Tab0\n# InfoMessage: Info about tab\nfluidPage(\nselectInput(ns(\"dataset\"), label = \"Dataset\", choices = ls(\"package:datasets\")),\n                                                          verbatimTextOutput(ns(\"summary\")),\n                                                          tableOutput(ns(\"table\"))\n                                                          )")
  app$set_inputs(`tab3-server1` = "  output$summary <- renderPrint({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          summary(dataset)\n                                                          })\n  \n                                                          output$table <- renderTable({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          dataset\n                                                          })")
  app$set_inputs(`tab3-config1` = " # --- Navigation ---\n                     # TabName: Tab Name\n                      # TabIcon: paper\n                         # --- Next/Prev buttons\n                        # ShowButtons: TRUE\n                     # --- Info ---\n                    # InfoTitle: Information\n                      # InfoMessage: Some info text")
  app$set_inputs(`tab3-EditTabs` = "1")
  app$click("tab3-newTab")
  app$set_inputs(`tab3-ui2` = "# --- Navigation ---\n# TabName: Tab1\n# TabIcon: file\n# --- Next/Prev buttons\n# ShowButtons: TRUE\n# ButtonsAlignment: center\n# --- Info ---\n# InfoTitle: Tab1\n# InfoMessage: Info about tab\nfluidPage(\nselectInput(ns(\"dataset\"), label = \"Dataset\", choices = ls(\"package:datasets\")),\n                                                          verbatimTextOutput(ns(\"summary\")),\n                                                          tableOutput(ns(\"table\"))\n                                                          )")
  app$set_inputs(`tab3-server2` = "  output$summary <- renderPrint({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          summary(dataset)\n                                                          })\n  \n                                                          output$table <- renderTable({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          dataset\n                                                          })")
  app$set_inputs(`tab3-config2` = " # --- Navigation ---\n                     # TabName: Tab Name\n                      # TabIcon: paper\n                         # --- Next/Prev buttons\n                        # ShowButtons: TRUE\n                     # --- Info ---\n                    # InfoTitle: Information\n                      # InfoMessage: Some info text")
  app$set_inputs(`tab3-EditTabs` = "2")
  app$click("tab3-newTab")
  app$set_inputs(`tab3-ui3` = "# --- Navigation ---\n# TabName: Tab2\n# TabIcon: file\n# --- Next/Prev buttons\n# ShowButtons: TRUE\n# ButtonsAlignment: center\n# --- Info ---\n# InfoTitle: Tab2\n# InfoMessage: Info about tab\nfluidPage(\nselectInput(ns(\"dataset\"), label = \"Dataset\", choices = ls(\"package:datasets\")),\n                                                          verbatimTextOutput(ns(\"summary\")),\n                                                          tableOutput(ns(\"table\"))\n                                                          )")
  app$set_inputs(`tab3-server3` = "  output$summary <- renderPrint({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          summary(dataset)\n                                                          })\n  \n                                                          output$table <- renderTable({\n                                                          dataset <- get(input$dataset, \"package:datasets\")\n                                                          dataset\n                                                          })")
  app$set_inputs(`tab3-config3` = " # --- Navigation ---\n                     # TabName: Tab Name\n                      # TabIcon: paper\n                         # --- Next/Prev buttons\n                        # ShowButtons: TRUE\n                     # --- Info ---\n                    # InfoTitle: Information\n                      # InfoMessage: Some info text")
  app$set_inputs(`tab3-EditTabs` = "3")
  app$set_inputs(`tab3-EditTabs` = "2")
  app$click("tab3-removeTab")
  app$set_inputs(`tab3-DelTabConfirmation` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`tab3-DelTabConfirmation` = TRUE, allow_no_input_binding_ = TRUE)
  app$click("NavBar-go_3_4")
  app$set_window_size(width = 1139, height = 731)
  # <-
  app$expect_unique_names()
})
