% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SiZer.R
\name{ggplot_SiZer}
\alias{ggplot_SiZer}
\title{Plot a SiZer map using `ggplot2`}
\usage{
ggplot_SiZer(x, colorlist = c("red", "purple", "blue", "grey"))
}
\arguments{
\item{x}{An object created using `SiZer()`}

\item{colorlist}{What colors should be used.  This is a vector that 
corresponds to 'decreasing', 'possibley zero', 'increasing', 
and 'insufficient data'.}
}
\description{
Plot a `SiZer` object that was created using `SiZer()`
}
\details{
The white lines in the SiZer map give a graphical representation 
         of the bandwidth.  The horizontal distance between the lines is \eqn{2h}.
}
\examples{
data('Arkansas')
x <- Arkansas$year
y <- Arkansas$sqrt.mayflies

plot(x,y)

# Calculate the SiZer map for the first derivative
SiZer.1 <- SiZer(x, y, h=c(.5,10), degree=1, derv=1, grid.length=21)
plot(SiZer.1)
plot(SiZer.1, ggplot2=TRUE)
ggplot_SiZer(SiZer.1)

# Calculate the SiZer map for the second derivative
SiZer.2 <- SiZer(x, y, h=c(.5,10), degree=2, derv=2, grid.length=21);
plot(SiZer.2)
plot(SiZer.2, ggplot2=TRUE)
ggplot_SiZer(SiZer.2)


# By setting the grid.length larger, we get a more detailed SiZer
# map but it takes longer to compute. 
#
# SiZer.3 <- SiZer(x, y, h=c(.5,10), grid.length=100, degree=1, derv=1)
# plot(SiZer.3)  
  
}
\references{
Chaudhuri, P., and J. S. Marron. 1999. SiZer for exploration of structures
    in curves. Journal of the American Statistical Association 94:807-823. 
    
  Hannig, J., and J. S. Marron. 2006. Advanced distribution theory for SiZer. 
    Journal of the American Statistical Association 101:484-499.
    
  Sonderegger, D.L., Wang, H., Clements, W.H., and Noon, B.R. 2009. Using SiZer to detect
    thresholds in ecological data. Frontiers in Ecology and the Environment 7:190-195.
}
\seealso{
\code{\link{plot.SiZer}}, \code{\link{locally.weighted.polynomial}}
}
\author{
Derek Sonderegger
}
