% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercorr_cont.R
\name{intercorr_cont}
\alias{intercorr_cont}
\title{Calculate Intermediate MVN Correlation for Continuous Variables Generated by Polynomial Transformation Method}
\usage{
intercorr_cont(method = c("Fleishman", "Polynomial"), constants = NULL,
  rho_cont = NULL)
}
\arguments{
\item{method}{the method used to generate the continuous variables.  "Fleishman" uses Fleishman's third-order polynomial transformation
and "Polynomial" uses Headrick's fifth-order transformation.}

\item{constants}{a matrix with each row a vector of constants c0, c1, c2, c3 (if \code{method} = "Fleishman") or
c0, c1, c2, c3, c4, c5 (if \code{method} = "Polynomial"), like that returned by
\code{\link[SimMultiCorrData]{find_constants}}}

\item{rho_cont}{a matrix of target correlations among continuous variables, does not have to be symmetric}
}
\value{
the intermediate matrix of correlations with the same dimensions as \code{rho_cont}
}
\description{
This function finds the intermediate correlation for standard normal random variables
    which are used in Fleishman's third-order (\doi{10.1007/BF02293811}) or Headrick's fifth-order
    (\doi{10.1016/S0167-9473(02)00072-5}) polynomial transformation method (PMT) using \code{\link[nleqslv]{nleqslv}}.  It is used in
    \code{\link[SimCorrMix]{intercorr}} and \code{\link[SimCorrMix]{intercorr2}} and would not ordinarily be called by the user.  The
    correlations are found pairwise so that eigen-value or principal components decomposition should be done on the resulting \code{Sigma}
    matrix. The \bold{Comparison of Correlation Methods 1 and 2} vignette contains the equations which were derived by Headrick and Sawilowsky
    (\doi{10.1007/BF02294317}) or Headrick (\doi{10.1016/S0167-9473(02)00072-5}).
}
\references{
Please see additional references for \code{\link[SimCorrMix]{SimCorrMix}}.

Fialkowski AC (2018). SimMultiCorrData: Simulation of Correlated Data with Multiple Variable Types. R package version 0.2.2.
    \url{https://CRAN.R-project.org/package=SimMultiCorrData}.

Headrick TC (2002). Fast Fifth-order Polynomial Transforms for Generating Univariate and Multivariate
    Non-normal Distributions. Computational Statistics & Data Analysis, 40(4):685-711. \doi{10.1016/S0167-9473(02)00072-5}.
    (\href{http://www.sciencedirect.com/science/article/pii/S0167947302000725}{ScienceDirect})

Headrick TC, Kowalchuk RK (2007). The Power Method Transformation: Its Probability Density Function, Distribution
    Function, and Its Further Use for Fitting Data. Journal of Statistical Computation and Simulation, 77:229-249. \doi{10.1080/10629360600605065}.

Headrick TC, Sawilowsky SS (1999). Simulating Correlated Non-normal Distributions: Extending the Fleishman Power
    Method. Psychometrika, 64:25-35. \doi{10.1007/BF02294317}.
}
\seealso{
\code{\link[SimCorrMix]{intercorr}}, \code{\link[SimCorrMix]{intercorr2}}, \code{\link[nleqslv]{nleqslv}}
}
\keyword{Fleishman,}
\keyword{Headrick}
\keyword{continuous,}
\keyword{correlation,}
