% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adat-helpers.R, R/getSomaScanLiftCCC.R
\name{adat-helpers}
\alias{adat-helpers}
\alias{getAdatVersion}
\alias{getSomaScanVersion}
\alias{getSignalSpace}
\alias{checkSomaScanVersion}
\alias{getSomaScanLiftCCC}
\title{Helpers to Extract Information from an ADAT}
\usage{
getAdatVersion(x)

getSomaScanVersion(adat)

getSignalSpace(adat)

checkSomaScanVersion(ver)

getSomaScanLiftCCC(matrix = c("plasma", "serum"))
}
\arguments{
\item{x}{Either a \code{soma_adat} object with intact attributes or
the attributes themselves of a \code{soma_adat} object.}

\item{adat}{A \code{soma_adat} object (with intact attributes),
typically created using \code{\link[=read_adat]{read_adat()}}.}

\item{ver}{\code{character(1)}. The SomaScan version as a string.
\strong{Note:} the \code{"v"}-prefix is case \emph{in}sensitive.}

\item{matrix}{Character. A string of (usually) either
\code{"serum"} or \code{"plasma"}.}
}
\value{
\item{\code{\link[=getAdatVersion]{getAdatVersion()}}}{The key-value of the \code{Version} as a string.}

\item{\code{\link[=getSomaScanVersion]{getSomaScanVersion()}}}{The key-value of the \code{AssayVersion} as a string.}

\item{\code{\link[=getSignalSpace]{getSignalSpace()}}}{The key-value of the \code{SignalSpace} as a string.}

\item{\code{\link[=checkSomaScanVersion]{checkSomaScanVersion()}}}{Returns \code{NULL} (invisibly) if checks pass.}

\item{\code{\link[=getSomaScanLiftCCC]{getSomaScanLiftCCC()}}}{Returns a tibble of either the
\code{serum} or \code{plasma} CCC between various versions of the SomaScan assay.}
}
\description{
Retrieve elements of the \code{HEADER} attribute of a \code{soma_adat} object:

\code{\link[=getAdatVersion]{getAdatVersion()}} determines the the ADAT version
number from a parsed ADAT header.

\code{\link[=getSomaScanVersion]{getSomaScanVersion()}} determines the original SomaScan assay version
that generated RFU measurements within a \code{soma_adat} object.

\code{\link[=checkSomaScanVersion]{checkSomaScanVersion()}} determines if the version of
is a recognized version of SomaScan.

Table of SomaScan assay versions:
\tabular{lcr}{
\strong{Version}  \tab \strong{Commercial Name} \tab \strong{Size} \cr
\code{V4}         \tab 5k                  \tab 5284     \cr
\code{v4.1}       \tab 7k                  \tab 7596     \cr
\code{v5.0}       \tab 11k                 \tab 11083    \cr
}
\code{\link[=getSignalSpace]{getSignalSpace()}} determines the current signal space of
the RFU values, which may differ from the original SomaScan
signal space if the data have been lifted. See \code{\link[=lift_adat]{lift_adat()}} and
\code{vignette("lifting-and-bridging", package = "SomaDataIO")}.

\code{\link[=getSomaScanLiftCCC]{getSomaScanLiftCCC()}} accesses the lifting Concordance Correlation
Coefficients between various SomaScan versions. For more about
CCC metrics see \code{\link[=lift_adat]{lift_adat()}}.
}
\examples{
getAdatVersion(example_data)

attr(example_data, "Header.Meta")$HEADER$Version <- "99.9"
getAdatVersion(example_data)

ver <- getSomaScanVersion(example_data)
ver

rfu_space <- getSignalSpace(example_data)
rfu_space

is.null(checkSomaScanVersion(ver))

# plasma (default)
getSomaScanLiftCCC()

# serum
getSomaScanLiftCCC("serum")
}
\references{
Lin, Lawrence I-Kuei. 1989. A Concordance Correlation
Coefficient to Evaluate Reproducibility. \strong{Biometrics}. 45:255-268.
}
\author{
Stu Field
}
