% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAttributes.R
\name{addAttributes}
\alias{addAttributes}
\title{Add Attributes to \code{soma_adat} Objects}
\usage{
addAttributes(data, new.atts)
}
\arguments{
\item{data}{The \emph{receiving} \code{data.frame} object for new attributes.}

\item{new.atts}{A \emph{named} \code{list} object containing new attributes
to add to the existing ones.}
}
\value{
A data frame object corresponding to \code{data} but with the
attributes of \code{new.atts} grafted on to it.
Existing attribute names are \emph{not} over-written.
}
\description{
Adds a set of attributes, typically "Header.Meta" and "Col.Meta",
to a \code{data.frame}, \code{tibble}, \code{soma_adat} or similar tabular object.
Existing attributes \code{data} are \emph{not} over-written.
Typically untouched are:
\itemize{
\item \code{names}
\item \code{class}
\item \code{row.names}
}
}
\seealso{
\code{\link[=attr]{attr()}}, \code{\link[=setdiff]{setdiff()}}
}
\author{
Stu Field
}
