% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subpop.R
\name{subpop}
\alias{subpop}
\title{Inference on Most and Least Affected Groups}
\usage{
subpop(
  fm,
  data,
  method = c("ols", "logit", "probit", "QR"),
  var_type = c("binary", "continuous", "categorical"),
  var,
  compare,
  subgroup = NULL,
  samp_weight = NULL,
  taus = c(5:95)/100,
  u = 0.1,
  alpha = 0.1,
  b = 500,
  seed = 1,
  parallel = FALSE,
  ncores = detectCores(),
  boot_type = c("nonpar", "weighted")
)
}
\arguments{
\item{fm}{Regression formula}

\item{data}{The data in use}

\item{method}{Models to be used for estimating partial effects. Four
options: \code{"logit"} (binary response),
\code{"probit"} (binary response), \code{"ols"}
(interactive linear with additive errors), \code{"QR"}
(linear model with non-additive errors). Default is
\code{"ols"}.}

\item{var_type}{The type of parameter in interest. Three options:
\code{"binary"}, \code{"categorical"},
\code{"continuous"}. Default is \code{"binary"}.}

\item{var}{Variable T in interset. Should be a character.}

\item{compare}{If parameter in interest is categorical, then user needs
to specify which two category to compare with. Should be
a 1 by 2 character vector. For example, if the two levels
to compare with is 1 and 3, then \code{c=("1", "3")},
which will calculate partial effect from 1 to 3. To use
this option, users first need to specify \code{var} as a
factor variable.}

\item{subgroup}{Subgroup in interest. Default is \code{NULL}.
Specifcation should be a logical variable. For example,
suppose data contains indicator variable for women
(female if 1, male if 0). If users are interested in
women SPE, then users should specify
\code{subgroup = data[, "female"] == 1}.}

\item{samp_weight}{Sampling weight of data. Input should be a n by 1 vector,
where n denotes sample size. Default is \code{NULL}.}

\item{taus}{Indexes for quantile regression.
Default is \code{c(5:95)/100}.}

\item{u}{Percentile of most and least affected. Default is set to
be 0.1.}

\item{alpha}{Size for confidence interval. Shoule be between 0 and 1.
Default is 0.1}

\item{b}{Number of bootstrap draws. Default is set to be 500.}

\item{seed}{Pseudo-number generation for reproduction. Default is 1.}

\item{parallel}{Whether the user wants to use parallel computation.
The default is \code{FALSE} and only 1 CPU will be used.
The other option is \code{TRUE}, and user can specify
the number of CPUs in the \code{ncores} option.}

\item{ncores}{Number of cores for computation. Default is set to be
\code{detectCores()}, which is a function from package
\code{parallel} that detects the number of CPUs on the
current host. For large dataset, parallel computing is
highly recommended since bootstrap is time-consuming.}

\item{boot_type}{Type of bootstrap. Default is \code{"nonpar"}, and the
package implements nonparametric bootstrap. The
alternative is \code{"weighted"}, and the package
implements weighted bootstrap.}
}
\description{
\code{subpop} conducts set inference on the groups of most and least
affected. When \code{subgroup = NULL}, output is for whole sample. Otherwise
the results are subgroup. The output of \code{subpop} is a list
containing six components: \code{cs_most}, \code{cs_least}, \code{u},
\code{subgroup}, \code{most} and \code{least}. As the names
indicate, \code{cs_most} and \code{cs_least} denote the confidence sets for
the most and least affected units. \code{u} stores the u-th most and least
affected index. \code{subgroup} stores the indicators for subpopulations.
\code{most} and \code{least} store the data of the most and
least affected groups. The confidence sets can be visualized using the
\code{\link{plot.subpop}} command while the two groups can be tabulated via
the \code{\link{summary.subpop}} command.
}
\examples{
data("mortgage")
### Regression Specification
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec +
   ltv_med + ltv_high + denpmi + selfemp + single + hischl
### Issue the subpop command
set_b <- subpop(fm, data = mortgage, method = "logit", var = "black",
u = 0.1, alpha = 0.1, b = 50)

}
