% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda2_calculator.R
\name{lambda2_calculator}
\alias{lambda2_calculator}
\title{Lambda 2 Calculator}
\usage{
lambda2_calculator(dat_l, dim, nclust, nboot = 1000, alpha2 = 0.5,
  delta = 1e-07, lambda1)
}
\arguments{
\item{dat_l}{list with D entries, each entry contains data d, p * n matrix.
This data should be centered and log-transformed.}

\item{dim}{Total number of conditions, D.}

\item{nclust}{Total number of clusters.}

\item{nboot}{The number of bootstrap repetitions for estimating lambda 2,
the default value is 1000.}

\item{alpha2}{The quantile of the bootstrapped lambda 2 values to use,
range is (0,1). The default value is 0.5, the median of the calculated
lambda 2 values.}

\item{delta}{Small term to ensure existance of solution, default is
0.0000001.}

\item{lambda1}{Calcualted penalty parameter for mean size.}
}
\value{
The estimated value of lambda2
}
\description{
Calculates the lambda 2 values for use in the main SparseMDC algorithm, the
lambda 2 value controls the number of genes that show condition-dependent
expression within each cell type. That is it controls the number of
different mean values across the conditions for each cluster. It is
calculated by estimating the value of lambda 2 that would result in no
difference in mean values across conditions when there are no meaningful
differences across between the conditions. For further details please see
the original manuscript.
}
\examples{
set.seed(10)
# Select small dataset for example
data_test <- data_biase[1:100,]
# Split data into condition A and B
data_A <- data_test[ , which(condition_biase == "A")]
data_B <- data_test[ , which(condition_biase == "B")]
data_C <- data_test[ , which(condition_biase == "C")]
# Store data as list
dat_l <- list(data_A, data_B, data_C)
# Pre-process the data
pdat <- pre_proc_data(dat_l, dim=3, norm = FALSE, log = TRUE,
center = TRUE)
lambda1 <- lambda1_calculator(pdat, dim = 3, nclust = 3)
lambda2 <- lambda2_calculator(pdat, dim = 3, nclust = 3, lambda1 = lambda1)
}
