#' Testing True Long Memory Against Spurious Long Memory
#'
#' Tests whether apparent long memory is genuine or spurious (caused by
#' level shifts or trends) using the method of Qu (2011).
#'
#' @section Main Functions:
#' \itemize{
#'   \item \code{\link{Longmemorytest}}: Test for the null hypothesis of true fractional integration against spurious long memory
#' }
#'
#' @section Data:
#' \itemize{
#'   \item \code{\link{RV5min}}: realized volatility for Japanese Yen/US dollar spot exchange rates
#' }
#' @references
#' Qu, Z. (2011). A Test Against Spurious Long Memory.
#' Journal of Business & Economic Statistics, 29(3), 423-438
#' <doi:10.1198/jbes.2010.09153>
#'
#' @docType package
#' @name SpuriousMemory
#' @keywords internal
"_PACKAGE"

NULL