% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{norm_fit}
\alias{norm_fit}
\title{Fit Normal Distribution to a Vector/stock prices.}
\usage{
norm_fit(vec)
}
\arguments{
\item{vec}{a numeric vector to be fitted with a normal distribution.}
}
\value{
A list with the following components:
\describe{
\item{par}{a numeric vector with the estimated mean and standard deviation
parameters of the fitted normal distribution.}
\item{aic}{a numeric value representing the Akaike information criterion (AIC)
of the fitted distribution.}
\item{bic}{a numeric value representing the Bayesian information criterion (BIC)
of the fitted distribution.}
}
}
\description{
This function takes a numeric vector and fits a normal distribution to it using the
fitdist function from the fitdistrplus package. It returns a list with the mean
and standard deviation parameters of the fitted normal distribution, as well as
the AIC and BIC values of the fitted distribution.
}
\examples{

# Fit a normal distribution to a vector of returns
stock_prices <- c(10, 11, 12, 13, 14, 17, 18)
returns <- diff(log(stock_prices))
norm_fit(returns)


}
\seealso{
\code{\link{t_fit}}, \code{\link{cauchy_fit}}, \code{\link{ghd_fit}}, \code{\link{hd_fit}},
\code{\link{sym.ghd_fit}}, \code{\link{sym.hd_fit}}, \code{\link{vg_fit}}, \code{\link{sym.vg_fit}},
\code{\link{nig_fit}}, \code{\link{ged_fit}}, \code{\link{skew.t_fit}}, \code{\link{skew.normal_fit}},
\code{\link{skew.ged_fit}}
}
