% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_get_comid.R
\name{lc_get_comid}
\alias{lc_get_comid}
\title{Get Lake COMIDs}
\usage{
lc_get_comid(
  dd = NULL,
  xcoord = NULL,
  ycoord = NULL,
  crsys = NULL,
  buffer = NULL
)
}
\arguments{
\item{dd}{Name of data frame object.  Can be a simple
data frame with coordinate columns in a known CRS or
an sf points data frame}

\item{xcoord}{The x coordinate column if using a raw data
frame}

\item{ycoord}{The y coordinate column if using a raw data 
frame}

\item{crsys}{The epsg code if using a raw data frame}

\item{buffer}{The amount of buffer to use to extend search for a waterbody 
(simply passed to nhdplusTools::get_waterbodies)}
}
\value{
A new sf data frame with a populated 'COMID' column
}
\description{
Function to return NHDPlusV2 Waterbody COMIDS using either a 
dataframe with coordinates and a specified CRS or an 
sf object.  The function generates a vector of NHDPlus Waterbody COMID
values a user can then pass to lc_get_data function
}
\examples{
\dontrun{

dd <- data.frame(x = c(-89.198,-114.125,-122.044),
y = c(45.502,47.877,43.730))

comids <- lc_get_comid(dd, xcoord='x',
                       ycoord='y', crsys=4269)

dd <- data.frame(x = c(-89.198,-114.125,-122.044),
y = c(45.502,47.877,43.730)) |> 
   sf::st_as_sf(coords = c('x', 'y'), crs = 4326)
   
comids <- lc_get_comid(dd)
 }
}
\author{
Marc Weber
}
