% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StructuralDecompose.R
\name{BreakPoints}
\alias{BreakPoints}
\title{Generation of breakpoints}
\usage{
BreakPoints(
  timeseries,
  frequency = 52,
  break_algorithm = "strucchange",
  break_level = 0.05
)
}
\arguments{
\item{timeseries}{Given time series}

\item{frequency}{Timeseries frequency, defaults to 12 points}

\item{break_algorithm}{Breakpoint algorithm to be used. Defaults to strucchange}

\item{break_level}{Additional parameters for breakpoint algorithm}
}
\value{
A list of breakpoints
}
\description{
Generation of breakpoints
}
\examples{
BreakPoints(timeseries = seq(100), frequency = 52, break_level = 0.05)
BreakPoints(timeseries = StructuralDecompose::Nile_dataset[,1], frequency = 52)
}
