% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnormtz.R
\name{rnormtz}
\alias{rnormtz}
\title{Simulate a stationary Gaussian time series.}
\usage{
rnormtz(n = 1, acf, Z, fft = TRUE, nkeep, tol = 1e-06)
}
\arguments{
\item{n}{Number of time series to generate.}

\item{acf}{Length-\code{N} vector giving the autocorrelation of the series.}

\item{Z}{Optional size \verb{(2N-2) x n} or \verb{N x n} matrix of iid standard normals, to use in the FFT and Durbin-Levinson methods, respectively.}

\item{fft}{Logical; whether or not to use the \verb{O(N log N)} FFT-based algorithm of Wood and Chan (1994) or the more stable \code{O(N^2)} Durbin-Levinson algorithm.  See Details.}

\item{nkeep}{Length of time series.  Defaults to \code{N = length(acf)}. See Details.}

\item{tol}{Relative tolerance on negative eigenvalues.  See Details.}
}
\value{
Length-\code{nkeep} vector or size \verb{nkeep x n} matrix with time series as columns.
}
\description{
Simulate a stationary Gaussian time series.
}
\details{
The FFT method fails when the embedding circulant matrix is not positive definite.  This is typically due to one of two things:
\enumerate{
\item Roundoff error can make tiny eigenvalues appear negative.  For this purpose, argument \code{tol} can be used to replace all negative eigenvalues by \code{tol * ev_max}, where \code{ev_max} is the largest eigenvalue.
\item The autocorrelation is decaying too slowly on the given timescale.  To mitigate this, argument \code{nkeep} can be used to supply a longer \code{acf} than is required, and keep only the first \code{nkeep} time series observations.  For consistency, \code{nkeep} also applies to Durbin-Levinson method.
}
}
\examples{
N <- 10
acf <- exp(-(1:N - 1)/N)
rnormtz(n = 3, acf = acf)
}
