% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_OrdOrd_copula.R
\name{estimate_ICA_OrdOrd}
\alias{estimate_ICA_OrdOrd}
\title{Estimate ICA in Ordinal-Ordinal Setting}
\usage{
estimate_ICA_OrdOrd(delta_S, delta_T)
}
\arguments{
\item{delta_S}{(integer) Vector of individual causal treatment effects on the
surrogate.}

\item{delta_T}{(integer) Vector of individual causal treatment effects on the
true endpoint.}
}
\value{
(numeric) Estimated ICA
}
\description{
\code{estimate_ICA_OrdOrd()} estimates the individual causal association (ICA) for
a sample of individual causal treatment effects with an ordinal surrogate and
true endpoint. The ICA in this setting is defined as follows: \deqn{R^2_H =
\frac{I(\Delta S; \Delta T)}{\min \{H(\Delta S), H(\Delta T) \}}} where
\eqn{I(\Delta S; \Delta T)} is the mutual information, and \eqn{H(\Delta S)}
and \eqn{H(\Delta T)} the entropy of \eqn{\Delta S} and \eqn{\Delta T},
respectively.
}
