% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Results.R
\name{Read_Results}
\alias{Read_Results}
\alias{read_results}
\title{Reads swimming and diving results into a list of strings in preparation for
parsing with \code{swim_parse}}
\usage{
Read_Results(file, node = "pre")

read_results(file, node = "pre")
}
\arguments{
\item{file}{a pdf, url or Hytek .hy3 file containing swimming
results.  Must be formatted in a "normal" fashion - see vignette}

\item{node}{a CSS node where html results are stored.  Required for html
results.  Default is "pre", which nearly always works.}
}
\value{
returns a list of strings containing the information from
  \code{file}.  Should then be parsed with \code{swim_parse}
}
\description{
Outputs list of strings to be processed by \code{swim_parse}
}
\examples{
\dontrun{
link <-
  "http://www.nyhsswim.com/Results/Boys/2008/NYS/Single.htm", node = "pre"
read_results(link)}

}
\seealso{
\code{read_results} is meant to be followed by
  \code{\link{swim_parse}}
}
