% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/course_conversions.R
\name{course_convert_DF}
\alias{course_convert_DF}
\alias{course_convert_df}
\title{Course converter, returns data frame - defunct}
\usage{
course_convert_DF(time, event, course, course_to)

course_convert_df(time, event, course, course_to)
}
\arguments{
\item{time}{A time, or vector of times to convert.  Can be in either seconds
(numeric, \code{95.97}) format or swim (character, \code{"1:35.97"}) format}

\item{event}{The event swum as \code{"100 Fly"}, \code{"200 IM"}, \code{"400
Free"}, \code{"50 Back"}, \code{"200 Breast"} etc.}

\item{course}{The course in which the time was swum as \code{"LCM"},
\code{"SCM"} or \code{"SCY"}}

\item{course_to}{The course to convert the time to as \code{"LCM"},
\code{"SCM"} or \code{"SCY"}}
}
\value{
This function returns a data frame including columns: \itemize{ \item
  Time \item Course \item Course_To \item Event \item Time_Converted_sec
  \item Time_Converted_mmss }
}
\description{
Used to convert times between Long Course Meters, Short Course Meters and
Short Course Yards, returns data frame
}
\note{
Relays are not presently supported.
}
\references{
Uses the USA swimming age group method described here
  \url{https://support.gomotionapp.com/en/articles/6457476-how-to-perform-course-conversion-factoring-of-times}
}
