% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hytek_toptimes_parse.R
\name{toptimes_parse_hytek}
\alias{toptimes_parse_hytek}
\title{Formats Hytek style swimming and diving Top Times reports read with
\code{read_results} into a data frame}
\usage{
toptimes_parse_hytek(
  file_hytek_toptimes,
  avoid_hytek_toptimes = avoid,
  typo_hytek_toptimes = typo,
  replacement_hytek_toptimes = replacement
)
}
\arguments{
\item{file_hytek_toptimes}{output from \code{read_results}}

\item{avoid_hytek_toptimes}{a list of strings.  Rows in
\code{file_hytek_toptimes} containing these strings will not be included.
For example "Pool:", often used to label pool records, could be passed to
\code{avoid_hytek_toptimes}.  The default is \code{avoid_default}, which
contains many strings similar to "Pool:", such as "STATE:" and "Qual:".
Users can supply their own lists to \code{avoid_hytek_toptimes}.
\code{avoid_hytek_toptimes} is handled before \code{typo_hytek_toptimes}
and \code{replacement_hytek_toptimes}.}

\item{typo_hytek_toptimes}{a list of strings that are typos in the original
results. \code{swim_parse} is particularly sensitive to accidental double
spaces, so "Central  High School", with two spaces between "Central" and
"High" is a problem, which can be fixed.  Pass "Central  High School" to
\code{typo_hytek_toptimes}. Unexpected commas as also an issue, for example
"Texas, University of" should be fixed using \code{typo_hytek_toptimes} and
\code{replacement_hytek_toptimes}}

\item{replacement_hytek_toptimes}{a list of fixes for the strings in
\code{typo_hytek}.  Here one could pass "Central High School" (one space
between "Central" and "High") and "Texas" to
\code{replacement_hytek_toptimes} fix the issues described in
\code{typo_hytek_toptimes}}
}
\value{
returns a data frame with columns \code{Rank}, \code{Result},
  \code{Name}, \code{Age}, \code{Date} \code{Meet} & \code{Event}.  Top Times
  reports do not designate Team.
}
\description{
Takes the output of \code{read_results} and cleans it, yielding a data frame
of swimming (and diving) top times
}
\seealso{
\code{toptimes_parse_hytek} must be run on the output of
  \code{\link{read_results}}
}
