% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{MasterGene}
\alias{MasterGene}
\title{Implements the master gene model in Marchani et al (2009)}
\usage{
MasterGene(mismatch, len, r = 0.013, plotFit = FALSE,
  main = sprintf("n = \%d", n))
}
\arguments{
\item{mismatch}{A vector containing the number of mismatches.}

\item{len}{A vector containing the length of each element.}

\item{r}{Mutation rate (substitutions/(million year * site)) used in the calculation.}

\item{plotFit}{Whether to plot the distribution fits.}

\item{main}{The title for the plot.}
}
\value{
This function returns various parameter estimates described in Marchani et al (2009), containing the following fields. The unit for time is million years ago (mya):
\item{B}{The constant insertion rate}
\item{q}{The constant excision rate}
\item{lam}{The population growth rate}
\item{R}{The ratio of the number of elements in class j over class j+1, which is constant by assumption}
\item{age1}{The age of the system under model 1 (lambda > 1)}
\item{age2}{The age of the system under model 2 (an initial burst followed by stasis lambda = 1)}
}
\description{
Implements the master gene model in Marchani et al (2009)
}
\details{
For the method implemented see References.
}
\examples{
# Analyze Gypsy family 24 (Nusif)
data(AetLTR)
dat <- subset(AetLTR, GroupID == 24 & !is.na(Chr))
res2 <- MasterGene(dat$Mismatch, dat$UngapedLen, plotFit=TRUE)
}
\references{
\cite{Marchani, Elizabeth E., Jinchuan Xing, David J. Witherspoon, Lynn B. Jorde, and Alan R. Rogers. "Estimating the age of retrotransposon subfamilies using maximum likelihood." Genomics 94, no. 1 (2009): 78-82.}
}
