\name{THSVM}
\alias{THSVM}
\title{
Theta-SVM hybrid model fitting
}

\description{
The THSVM function fit THETA-SVM hybrid model for time series data.
}

\usage{
THSVM(data,h)
}

\arguments{
  \item{data}{
Input univariate time series (ts) data.}
\item{h}{
The forecast horizon.
}
}

\details{
This package allows you to fit the THETA-SVM hybrid model.
}

\value{
  \item{Test_Result}{Checking the suitability of data for hybrid modelling}
  \item{THETA coefficients}{Coefficients of the fitted THETA}
  \item{SVM Summary}{Summary of the fitted SVM model on residuals obtained from
  the fitted THETA model}
   \item{Optimal Lag}{Optimal Lag of the fitted SVM model}
  \item{MAPE}{Mean Absolute Percentage Error (MAPE) of the fitted hybrid model}
  \item{MSE}{Mean Square Error (MSE) of fitted hybrid model}
  \item{fitted }{Fitted values of hybrid model}
   \item{forecasted.values}{h step ahead forecasted values employing hybrid
   model}
}

\references{
Bhattacharyya, A., Chakraborty, T., and Rai, S. N. (2022).
Stochastic forecasting of COVID-19 daily new cases across countries with a novel
hybrid time series model. Nonlinear Dynamics, 107(3), 3025–3040.
}
\author{
Fasila K. P., Mrinmoy Ray, Rajeev Ranjan Kumar, K. N. Singh,
Amrender Kumar, Santosha Rathod
}

\seealso{
 ARSVM, ARIMAANN
}

\examples{
data=lynx
THSVM(data,5)
}

\keyword{ THETA-SVM}
