% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R, R/generics.R,
%   R/memoMDB.R, R/metaMDB.R
\name{filter_with_tables.chMDB}
\alias{filter_with_tables.chMDB}
\alias{filter_with_tables.fileMDB}
\alias{filter_with_tables}
\alias{filter_with_tables.memoMDB}
\alias{filter_with_tables.metaMDB}
\title{Filter an \link{MDB} object according to provided tables}
\usage{
\method{filter_with_tables}{chMDB}(x, tables, checkTables = TRUE, by = 10^5, ...)

\method{filter_with_tables}{fileMDB}(x, tables, checkTables = TRUE, by = 10^5, ...)

filter_with_tables(x, tables, checkTables = TRUE, ...)

\method{filter_with_tables}{memoMDB}(x, tables, checkTables = TRUE, ...)

\method{filter_with_tables}{metaMDB}(x, tables, checkTables = TRUE, ...)
}
\arguments{
\item{x}{an \link{MDB} object}

\item{tables}{a named list of tibbles to filter with. The names should
correspond to the table names in x and the tibbles should fit the
data model.}

\item{checkTables}{if TRUE, the tables are confronted to their model
in the data model of x.}

\item{by}{the size of the batch: number of lines to process
together (default: 10000)}

\item{...}{method specific parameters}
}
\value{
a \link{memoMDB} object
}
\description{
Filter an \link{MDB} object according to provided tables
}
