% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tropical.HAR.Centroid.R
\name{tropical.centroid}
\alias{tropical.centroid}
\alias{VE.HAR.centroid}
\title{Tropical centroid-based sampling about a center of mass}
\usage{
VE.HAR.centroid(D_s, x0, I = 1, m, s, tadd = max)
}
\arguments{
\item{D_s}{matrix of vertices of a tropical simplex; each row is a vertex}

\item{x0}{initial point for sampler, numeric vector}

\item{I}{number of states in Markov chain}

\item{m}{location parameter; numeric vector indicating centroid}

\item{s}{scale parameter; in terms of tropical distance}

\item{tadd}{function; max indicates max-plus addition, min indicates
min-plus addition. Defaults to max}
}
\value{
next sampled point from the tropical polytope
}
\description{
This function is a centroid-based HAR sampler about a center of mass denoted
by a location parameter with scale parameter in terms of the tropical
distance
}
\examples{
D_s <-matrix(c(0,10,10,0,10,0,0,0,10),3,3,TRUE)
x0 <- c(0,0,0)
m <- c(0,5,5)
s <- 1
VE.HAR.centroid(D_s, x0, I = 50,m,s)
VE.HAR.centroid(D_s, x0, I = 50,m,s,tadd=min)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
