% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_csv.R
\name{df_to_csv}
\alias{df_to_csv}
\title{Convert a data.frame to a CSV-formatted character string}
\usage{
df_to_csv(df)
}
\arguments{
\item{df}{A data.frame to be converted to a CSV-formatted character string.}
}
\value{
A character string representing the data values in the input data.frame
  formatted as a CSV file.
}
\description{
The `df_to_csv` function takes a data.frame as input and returns a character
string representing the content of the original data.frame formatted as a CSV file.
The resulting CSV-formatted string can be written to a file or further processed
as needed.
}
\examples{
# Create a data.frame
example_data <- data.frame(
  Name = c("Alice", "Bob", "Carol"),
  Age = c(30, 25, 28),
  Height = c(168, 175, 162),
  stringsAsFactors = FALSE
)

# Convert the data.frame to a CSV-formatted character string
csv_string <- df_to_csv(example_data)
cat(csv_string)
}
