% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_blocks.R
\name{extract_blocks}
\alias{extract_blocks}
\title{Extract blocks of a specified type from a list of blocks}
\usage{
extract_blocks(block_list, block_type)
}
\arguments{
\item{block_list}{A list of blocks}

\item{block_type}{The type of blocks to be extracted}
}
\value{
A list of blocks of the specified type
}
\description{
Extract blocks of a specified type from a list of blocks
}
\examples{
\dontrun{
# Example 1: Extract 'code' blocks
blocks <- list(
  list(type = "text", content = "Hello world!"),
  list(type = "code", content = "print('Hello world!')")
)
extract_blocks(blocks, "code")
# Output:
# [[1]]
# $type
# [1] "code"
#
# $content
# [1] "print('Hello world!')"

# Example 2: Extract 'text' blocks
blocks <- list(
  list(type = "text", content = "Hello world!"),
  list(type = "code", content = "print('Hello world!')")
)
extract_blocks(blocks, "text")
# Output:
# [[1]]
# $type
# [1] "text"
#
# $content
# [1] "Hello world!"
}
}
\author{
Jonathan Chassot
}
