% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_entities.R
\name{extract_entities}
\alias{extract_entities}
\title{Extract Entities from a Text}
\usage{
extract_entities(
  text,
  entity_types = c("locations", "persons", "organizations"),
  batch_size = NULL
)
}
\arguments{
\item{text}{A character string containing the text to be processed, or a path to a text file}

\item{entity_types}{A character vector containing names of entity types to be extracted. Defaults to c("locations", "persons", "organizations").}

\item{batch_size}{An integer indicating the size of each batch, if the text input is supposed to be processed in batches. Set this to NULL to process all at once.}
}
\value{
A tibble
}
\description{
This function takes a character string or a path to a text file and returns a tibble describing the entities found in the text.
The type of entities to be searched for and extracted can be defined by the user.
}
\examples{
 \dontrun{
extract_entities("Hello, how are you?")
extract_entities("path/to/text/file.txt",  batch_size = 100)
}

}
\author{
Ulrich Matter umatter@protonmail.com
}
