% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.xblocks.any.R
\name{get.xblocks.any}
\alias{get.xblocks.any}
\title{Get extra blocks in a Thurstonian design, that links as few blocks as possible.}
\usage{
get.xblocks.any(blocks, itf, multidim)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{multidim}{Logical. Should the items within each linking block be
forced to be multidimensional?}
}
\value{
The result is a matrix where the rows correspond to the specific
extra blocks.
}
\description{
The function creates extra blocks in a Thurstonian design, that links as few
initial blocks as possible, with the number of blocks determined by
`count.xblocks`. This is only useful for comparisons between linked and
partially linked block designs (Jansen & Schulze, 2023).
}
\details{
The main strategy of the function is to create extra blocks that
link as few blocks as possible, with the number of blocks determined by
`count.xblocks`. Therefore, first all combinations of additional blocks with
the first two blocks are created. If more extra blocks are needed the
function uses block three, four, etc..
}
\examples{

# Define a matrix of blocks
blocks <- matrix(1:15,ncol=3, byrow=TRUE)

# define the item-to-factor relation
itf <- rep(1:3,5)

# Get the extra blocks for a partially linked design
get.xblocks.any(blocks, itf, FALSE)

}
\references{
Jansen, M. T., & Schulze, R. (2023). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.
}
