% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.name.R
\name{i.name}
\alias{i.name}
\title{Creates names for paired comparisons of a given design.}
\usage{
i.name(blocks)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}
}
\value{
Returns a character vector, containing names for all binary indicators
of a design.
}
\description{
This function creates names for paired comparisons in the ixiy scheme. If
items 1 and 2 are compared, this corresponds to i1i2.
}
\examples{

# Define 30 items divided by ten triplets as blocks
blocks <- matrix(c(1:30), ncol = 3)

i.name(blocks)
    
}
