% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankA.R
\name{rankA}
\alias{rankA}
\title{Determine the rank of the design matrix defined by the blocks.}
\usage{
rankA(blocks)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}
}
\value{
Returns the rank of the design matrix as an integer.
}
\description{
This function determines the rank of the fundamental design matrix defined
by the blocks.
}
\examples{

# Define nine items divided by three triplets as blocks
blocks <- matrix(c(1:9), ncol = 3)

# Determine the rank of the design matrix
rankA(blocks)
    
}
