% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiqc.R
\name{load_multiqc}
\alias{load_multiqc}
\title{Loads one or more MultiQC reports into a data frame}
\usage{
load_multiqc(
  paths,
  plots = NULL,
  find_metadata = function(...) {     list() },
  plot_parsers = list(),
  sections = "general"
)
}
\arguments{
\item{paths}{A string vector of filepaths to multiqc_data.json files}

\item{plots}{A string vector, each of which contains the ID of a plot you
want to include in the output. You can use \code{\link[=list_plots]{list_plots()}} to help here.}

\item{find_metadata}{A single function that will be called with a sample name and the
parsed JSON for the entire report and returns a named list of metadata fields for the sample.
Refer to the vignette for an example.}

\item{plot_parsers}{\strong{Advanced}. A named list of custom parser functions.
The names of the list should correspond to plotly plot types, such as "xy_line", and the values should be functions
that return a named list of named lists. For the return value, the outer list is named by the sample ID, and the inner list
is named by the name of the column. Refer to the source code for some examples.}

\item{sections}{A string vector of zero or more sections to include in the output.
Each section can be:
\describe{
\item{"plot"}{Parse plot data. Note that you should also provide a list of plots via the \code{plots} argument}
\item{"general"}{parse the general stat section}
\item{"raw"}{Parse the raw data section}
}
This defaults to 'general', which tends to contain the most useful statistics}
}
\value{
A tibble (data.frame subclass) with QC data and metadata as columns, and samples as rows.
Columns are named according to the respective section they belong to,
and will always be listed in the following order:
\item{\code{metadata.X}}{This column contains metadata for this sample.
By default this is only the sample ID, but if you have provided the
\code{find_metadata} argument, there may be more columns.}
\item{\code{general.X}}{This column contains a generally useful summary statistic for each sample}
\item{\code{plot.X}}{This column contains a data frame of plot data for each sample.
Refer to the plot parsers documentation (ie the \code{parse_X} functions) for more information on the output format. }
\item{\code{raw.X}}{This column contains a raw summary statistic or value relating to each sample }
}
\description{
Loads one or more MultiQC reports into a data frame
}
\examples{
load_multiqc(system.file("extdata", "wgs/multiqc_data.json", package = "TidyMultiqc"))
}
\seealso{
\code{\link[=parse_xyline_plot]{parse_xyline_plot()}} \code{\link[=parse_bar_graph]{parse_bar_graph()}}
}
