% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-spatial.R
\name{dms_to_decimal}
\alias{dms_to_decimal}
\title{Convert latitude or longitude to decimal degrees}
\usage{
dms_to_decimal(coordinates, hemisphere = "S", correct_errors = TRUE)
}
\arguments{
\item{coordinates}{Character vector. Each element should be in formats such as:
"D M S", "D M", "17 26 S"}

\item{hemisphere}{Character indicating hemisphere when not specified in the coordinate.
One of "N", "S", "E", "W" or "O". "S" and "W"/"O" generate negative values.}

\item{correct_errors}{Logical. If TRUE, automatically corrects out-of-range values.}
}
\value{
Numeric vector with coordinates converted to decimal degrees.
}
\description{
Converts coordinates expressed in degrees, minutes and seconds (DMS) or degrees and minutes (DM)
format to decimal degrees. By default, coordinates are assumed to be in the southern hemisphere
(negative latitudes). The function can automatically correct common errors such as minutes or
seconds greater than 60.
}
\examples{
dms_to_decimal(c("73 15 0"), hemisphere = "W")

}
