% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_methods.R
\name{compare_univariate_methods}
\alias{compare_univariate_methods}
\title{Compare Univariate Outlier Detection Methods}
\usage{
compare_univariate_methods(data, methods, params)
}
\arguments{
\item{data}{Input dataset (must be a data.frame)}

\item{methods}{Vector of method names to compare. Available methods are:
"z_score", "boxandwhiskers"}

\item{params}{List of parameters for each method. Must contain named lists:
\itemize{
  \item z_score: list(d=numeric)
  \item boxandwhiskers: list(d=numeric)
}}
}
\value{
None, produces a visualization matrix comparing the outliers detected by each method.
}
\description{
Compares univariate outlier detection methods on the flattened dataset
}
\examples{
inputData = t(matrix(c(3,2,3.5,12,4.7,4.1,5.2,
4.9,7.1,6.1,6.2,5.2,14,5.3),2,7,dimnames=list(c("r","d"))))
inputData = data.frame(inputData)
methods = c("z_score", "boxandwhiskers")
params = list(
  z_score = list(d=2),
  boxandwhiskers = list(d=2)
)
compare_univariate_methods(inputData, methods, params)

}
\author{
Andriy Protsak
}
