% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_method.R
\name{mahalanobis_method}
\alias{mahalanobis_method}
\title{mahalanobis_method}
\usage{
mahalanobis_method(inputData, alpha, learn)
}
\arguments{
\item{inputData}{Input Data dataset that will be processed (with or not the step by step explanation) to obtain the underlying outliers. It must be a data.frame type.}

\item{alpha}{Significance level alpha. This value indicates the proportion that it is expected to be outliers out of the dataset. It has to be in the range from 0 to 1}

\item{learn}{if TRUE the tutorial mode is activated (the algorithm will include an explanation detailing the theory behind the outlier detection algorithm and a step by step explanation of how is the data processed to obtain the outliers following the theory mentioned earlier)}
}
\value{
Numeric vector containing the indices of detected outliers.
}
\description{
Detect outliers using the Mahalanobis Distance method
}
\examples{
inputData = t(matrix(c(3,2,3.5,12,4.7,4.1,5.2,
4.9,7.1,6.1,6.2,5.2,14,5.3),2,7,dimnames=list(c("r","d"))));
inputData = data.frame(inputData);
mahalanobis_method(inputData, 0.7, FALSE); #Can be set to TRUE

}
\author{
Andres Missiego Manjon
}
