% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agglomerative_clustering.R
\name{agglomerative_clustering}
\alias{agglomerative_clustering}
\title{Agglomerative Hierarchical Clustering}
\usage{
agglomerative_clustering(
  data,
  proximity = "single",
  distance_method = "euclidean",
  learn = FALSE,
  waiting = TRUE,
  ...
)
}
\arguments{
\item{data}{a set of observations, presented as a matrix-like object where
every row is a new observation.}

\item{proximity}{the proximity definition to be used. This should be one
of \code{"single"} (minimum/single linkage), \code{"complete"} (maximum/
complete linkage), \code{"average"} (average linkage).}

\item{distance_method}{the distance measure to use. Supported values are:
\itemize{
\item 'euclidean': Standard Euclidean distance
\item 'manhattan': Manhattan (city-block) distance
\item 'canberra': Canberra distance
\item 'chebyshev': Chebyshev (maximum) distance
}}

\item{learn}{a Boolean determining whether intermediate logs explaining how
the algorithm works should be printed or not.}

\item{waiting}{a Boolean determining whether the intermediate logs should be
printed in chunks waiting for user input before printing the next or not.}

\item{...}{additional arguments passed to \code{\link[proxy:dist]{proxy::dist()}}.}
}
\value{
An \code{\link[stats:hclust]{stats::hclust()}} object which describes the tree produced by the
clustering process.
}
\description{
Perform a hierarchical agglomerative cluster analysis on a set
of observations
}
\details{
This function performs a hierarchical cluster analysis for the
\eqn{n} objects being clustered. The definition of a set of clusters using
this method follows a \eqn{n} step process, which repeats until a single
cluster remains:

\enumerate{
\item Initially, each object is assigned to its own cluster. The matrix
of distances between clusters is computed.
\item The two clusters with closest proximity will be joined together and
the proximity matrix updated. This is done according to the specified
\code{proximity}. This step is repeated until a single cluster remains.
}

The definitions of \code{proximity} considered by this function are:

\describe{
\item{\code{single}}{\eqn{\min\left\{d(x,y):x\in A,y\in B\right\}}. Defines
the proximity between two clusters as the distance between the closest
objects among the two clusters. It produces clusters where each object is
closest to at least one other object in the same cluster. It is known as
\strong{SLINK}, \strong{single-link} and \strong{minimum-link}.}
\item{\code{complete}}{\eqn{\max\left\{d(x,y):x\in A,y\in B\right\}}.
Defines the proximity between two clusters as the distance between the
furthest objects among the two clusters. It is known as \strong{CLINK},
\strong{complete-link} and \strong{maximum-link}.}
\item{\code{average}}{\eqn{\frac{1}{\left|A\right|\cdot\left|B\right|}
 \sum_{x\in A}\sum_{y\in B} d(x,y)}. Defines the proximity between two
clusters as the average distance between every pair of objects, one from
each cluster. It is also known as \strong{UPGMA} or \strong{average-link}.}
}
}
\examples{

cl <- agglomerative_clustering(
  db5[1:6, ],
  'single',
  learn = TRUE,
  waiting = FALSE
)

}
\author{
Eduardo Ruiz Sabajanes, \email{eduardo.ruizs@edu.uah.es}
}
