% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitAndResiduals.R
\name{FitAndResiduals}
\alias{FitAndResiduals}
\title{Computes a linear regression fit and residuals 
 on possibly multivariate responses}
\usage{
FitAndResiduals(Y, X, BetaHat)
}
\arguments{
\item{Y}{a numeric matrix, to act as response}

\item{X}{a numeric matrix, to act as covariates}

\item{BetaHat}{a numeric matrix, to act as slope}
}
\value{
a list consisting of two vectors, the 
		fitted values and residuals
}
\description{
Computes a linear regression fit and residuals 
 on possibly multivariate responses
}
\examples{
 \dontrun{
 DataY = cbind(CCU12_Precip$Precip, CCU12_Precip$TMax);
DataX = cbind(rep(1, length(CCU12_Precip$Precip)), CCU12_Precip$TMin)			
BetaHat.New = WLS(DataY, DataX)
Results.New = FitAndResiduals(DataY, DataX, BetaHat.New);
    		}


}
