#' @family pooled estimates (two-sample)
#' @inherit uM6pool title description params
#' @return Pooled estimate of squared third central moment
#'   \eqn{\mu_3^2}{\mu[3]^2}, where \eqn{\mu_3}{\mu[3]} is a third central
#'   moment.
#' @examples
#' nx <- 10
#' ny <- 8
#' shp <- 3
#' smpx <- rgamma(nx, shape = shp) - shp
#' smpy <- rgamma(ny, shape = shp)
#' mx <- mean(smpx)
#' my <- mean(smpy)
#' m  <- numeric(6)
#' for (j in 2:6) {
#'   m[j] <- mean(c((smpx - mx)^j, (smpy - my)^j))
#' }
#' uM3pow2pool(m[2], m[3], m[4], m[6], nx, ny)
#' @export
uM3pow2pool <- function(m2, m3, m4, m6, n_x, n_y) {
    (m3^2*n_x^7*n_y^15 + (8*m3^2*n_x^8 + 21*m3^2*n_x^6 - (9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^7 - 23*m3^2*n_x^5 + 15*m3^2*n_x^4 - 5*m3^2*n_x^3)*n_y^14 + (28*m3^2*n_x^9 - 7*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^8 + (261*m2^3 + 551*m3^2 - 159*m2*m4 + 26*m6)*n_x^7 - (240*m2^3 + 572*m3^2 - 138*m2*m4 + 19*m6)*n_x^6 + (195*m2^3 + 577*m3^2 - 99*m2*m4 + 15*m6)*n_x^5 + (60*m2^3 - 365*m3^2 - 30*m2*m4 - 4*m6)*n_x^4 - 75*m3^2*n_x^2 - 5*(21*m2^3 - 35*m3^2 - 9*m2*m4)*n_x^3 + 15*m3^2*n_x)*n_y^13 + (56*m3^2*n_x^10 - 21*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^9 + 6*(261*m2^3 + 481*m3^2 - 159*m2*m4 + 26*m6)*n_x^8 - 3*(1358*m2^3 + 1869*m3^2 - 749*m2*m4 + 120*m6)*n_x^7 + (5151*m2^3 + 6171*m3^2 - 2571*m2*m4 + 353*m6)*n_x^6 - (4809*m2^3 + 5404*m3^2 - 2103*m2*m4 + 291*m6)*n_x^5 + (2418*m2^3 + 3150*m3^2 - 1005*m2*m4 + 158*m6)*n_x^4 - 5*(228*m2^3 + 263*m3^2 - 93*m2*m4 + 12*m6)*n_x^3 + 3*(225*m2^3 + 120*m3^2 - 60*m2*m4 + 4*m6)*n_x^2 - 15*(6*m2^3 + m3^2)*n_x)*n_y^12 + (70*m3^2*n_x^11 - 35*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^10 + 3*(1305*m2^3 + 2307*m3^2 - 795*m2*m4 + 130*m6)*n_x^9 - (17010*m2^3 + 20717*m3^2 - 9303*m2*m4 + 1534*m6)*n_x^8 + 2*(17229*m2^3 + 16490*m3^2 - 8304*m2*m4 + 1364*m6)*n_x^7 - (41775*m2^3 + 32370*m3^2 - 17031*m2*m4 + 2531*m6)*n_x^6 + (34050*m2^3 + 22214*m3^2 - 10488*m2*m4 + 1681*m6)*n_x^5 - 2*(8367*m2^3 + 4735*m3^2 - 1635*m2*m4 + 352*m6)*n_x^4 + (6720*m2^3 + 2315*m3^2 - 450*m2*m4 + 168*m6)*n_x^3 - 3*(1005*m2^3 + 60*m3^2 + 30*m2*m4 + 4*m6)*n_x^2 + 15*(42*m2^3 - m3^2)*n_x)*n_y^11 + (56*m3^2*n_x^12 - 35*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^11 + 10*(522*m2^3 + 913*m3^2 - 318*m2*m4 + 52*m6)*n_x^10 - (32340*m2^3 + 37913*m3^2 - 17640*m2*m4 + 2935*m6)*n_x^9 + (94593*m2^3 + 85238*m3^2 - 44877*m2*m4 + 7975*m6)*n_x^8 - (149901*m2^3 + 108581*m3^2 - 58953*m2*m4 + 11281*m6)*n_x^7 + 2*(74895*m2^3 + 42449*m3^2 - 21501*m2*m4 + 4395*m6)*n_x^6 - (95568*m2^3 + 40156*m3^2 - 12228*m2*m4 + 4421*m6)*n_x^5 + (36186*m2^3 + 9590*m3^2 + 2535*m2*m4 + 1288*m6)*n_x^4 - 3*(3505*m2^3 + 175*m3^2 + 710*m2*m4 + 56*m6)*n_x^3 + 6*(600*m2^3 - 85*m3^2 + 135*m2*m4 - 2*m6)*n_x^2 - 15*(48*m2^3 - m3^2)*n_x)*n_y^10 + (28*m3^2*n_x^13 - 21*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^12 + 3*(1305*m2^3 + 2307*m3^2 - 795*m2*m4 + 130*m6)*n_x^11 - (32340*m2^3 + 37913*m3^2 - 17640*m2*m4 + 2935*m6)*n_x^10 + 2*(65091*m2^3 + 57867*m3^2 - 30741*m2*m4 + 5585*m6)*n_x^9 - (275031*m2^3 + 198491*m3^2 - 106695*m2*m4 + 23189*m6)*n_x^8 + (334023*m2^3 + 194763*m3^2 - 95469*m2*m4 + 26663*m6)*n_x^7 - (256164*m2^3 + 111397*m3^2 - 36222*m2*m4 + 17001*m6)*n_x^6 + 3*(38618*m2^3 + 9859*m3^2 + 4272*m2*m4 + 2070*m6)*n_x^5 - 6*(4185*m2^3 - 95*m3^2 + 2455*m2*m4 + 159*m6)*n_x^4 + 180*m2^3*n_x + 3*(1020*m2^3 - 545*m3^2 + 1170*m2*m4 - 12*m6)*n_x^3 - 3*(360*m2^3 - 195*m3^2 + 240*m2*m4 - 4*m6)*n_x^2)*n_y^9 + (8*m3^2*n_x^14 - 7*(9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^13 + 6*(261*m2^3 + 481*m3^2 - 159*m2*m4 + 26*m6)*n_x^12 - (17010*m2^3 + 20717*m3^2 - 9303*m2*m4 + 1534*m6)*n_x^11 + (94593*m2^3 + 85238*m3^2 - 44877*m2*m4 + 7975*m6)*n_x^10 - (275031*m2^3 + 198491*m3^2 - 106695*m2*m4 + 23189*m6)*n_x^9 + 2*(215760*m2^3 + 129104*m3^2 - 61905*m2*m4 + 19396*m6)*n_x^8 - (397530*m2^3 + 188691*m3^2 - 66231*m2*m4 + 36742*m6)*n_x^7 + (228387*m2^3 + 73538*m3^2 + 1989*m2*m4 + 19236*m6)*n_x^6 - 15*(4616*m2^3 + 521*m3^2 + 1578*m2*m4 + 346*m6)*n_x^5 + 240*(15*m2^3 - 8*m3^2 + 33*m2*m4 + m6)*n_x^4 + 6*(390*m2^3 + 25*m3^2 + 28*m6)*n_x^3 - 180*(m2^3 + m3^2 - m2*m4)*n_x^2)*n_y^8 + (m3^2*n_x^15 - (9*m2^3 + 32*m3^2 - 6*m2*m4 + m6)*n_x^14 + (261*m2^3 + 551*m3^2 - 159*m2*m4 + 26*m6)*n_x^13 - 3*(1358*m2^3 + 1869*m3^2 - 749*m2*m4 + 120*m6)*n_x^12 + 2*(17229*m2^3 + 16490*m3^2 - 8304*m2*m4 + 1364*m6)*n_x^11 - (149901*m2^3 + 108581*m3^2 - 58953*m2*m4 + 11281*m6)*n_x^10 + (334023*m2^3 + 194763*m3^2 - 95469*m2*m4 + 26663*m6)*n_x^9 - (397530*m2^3 + 188691*m3^2 - 66231*m2*m4 + 36742*m6)*n_x^8 + 2*(142674*m2^3 + 51581*m3^2 - 8022*m2*m4 + 14158*m6)*n_x^7 - 3*(43210*m2^3 + 9505*m3^2 + 3820*m2*m4 + 3956*m6)*n_x^6 + 6*(4785*m2^3 + 235*m3^2 + 1635*m2*m4 + 386*m6)*n_x^5 + 6*(150*m2^3 - 125*m3^2 + 60*m2*m4 + 4*m6)*n_x^4 - 72*(15*m2^3 - 5*m3^2 + 10*m2*m4 + m6)*n_x^3)*n_y^7 + (21*m3^2*n_x^14 - (240*m2^3 + 572*m3^2 - 138*m2*m4 + 19*m6)*n_x^13 + (5151*m2^3 + 6171*m3^2 - 2571*m2*m4 + 353*m6)*n_x^12 - (41775*m2^3 + 32370*m3^2 - 17031*m2*m4 + 2531*m6)*n_x^11 + 2*(74895*m2^3 + 42449*m3^2 - 21501*m2*m4 + 4395*m6)*n_x^10 - (256164*m2^3 + 111397*m3^2 - 36222*m2*m4 + 17001*m6)*n_x^9 + (228387*m2^3 + 73538*m3^2 + 1989*m2*m4 + 19236*m6)*n_x^8 - 3*(43210*m2^3 + 9505*m3^2 + 3820*m2*m4 + 3956*m6)*n_x^7 + 12*(4200*m2^3 + 365*m3^2 + 765*m2*m4 + 342*m6)*n_x^6 - 12*(840*m2^3 - 80*m3^2 + 330*m2*m4 + 57*m6)*n_x^5 + 180*(m2^3 + m3^2 - m2*m4)*n_x^4)*n_y^6 - (23*m3^2*n_x^14 - (195*m2^3 + 577*m3^2 - 99*m2*m4 + 15*m6)*n_x^13 + (4809*m2^3 + 5404*m3^2 - 2103*m2*m4 + 291*m6)*n_x^12 - (34050*m2^3 + 22214*m3^2 - 10488*m2*m4 + 1681*m6)*n_x^11 + (95568*m2^3 + 40156*m3^2 - 12228*m2*m4 + 4421*m6)*n_x^10 - 3*(38618*m2^3 + 9859*m3^2 + 4272*m2*m4 + 2070*m6)*n_x^9 + 15*(4616*m2^3 + 521*m3^2 + 1578*m2*m4 + 346*m6)*n_x^8 - 6*(4785*m2^3 + 235*m3^2 + 1635*m2*m4 + 386*m6)*n_x^7 + 12*(840*m2^3 - 80*m3^2 + 330*m2*m4 + 57*m6)*n_x^6 - 72*(25*m2^3 - 10*m3^2 + 20*m2*m4 + 2*m6)*n_x^5)*n_y^5 + (15*m3^2*n_x^14 + (60*m2^3 - 365*m3^2 - 30*m2*m4 - 4*m6)*n_x^13 + (2418*m2^3 + 3150*m3^2 - 1005*m2*m4 + 158*m6)*n_x^12 - 2*(8367*m2^3 + 4735*m3^2 - 1635*m2*m4 + 352*m6)*n_x^11 + (36186*m2^3 + 9590*m3^2 + 2535*m2*m4 + 1288*m6)*n_x^10 - 6*(4185*m2^3 - 95*m3^2 + 2455*m2*m4 + 159*m6)*n_x^9 + 240*(15*m2^3 - 8*m3^2 + 33*m2*m4 + m6)*n_x^8 + 6*(150*m2^3 - 125*m3^2 + 60*m2*m4 + 4*m6)*n_x^7 + 180*(m2^3 + m3^2 - m2*m4)*n_x^6)*n_y^4 - (5*m3^2*n_x^14 + 5*(21*m2^3 - 35*m3^2 - 9*m2*m4)*n_x^13 + 5*(228*m2^3 + 263*m3^2 - 93*m2*m4 + 12*m6)*n_x^12 - (6720*m2^3 + 2315*m3^2 - 450*m2*m4 + 168*m6)*n_x^11 + 3*(3505*m2^3 + 175*m3^2 + 710*m2*m4 + 56*m6)*n_x^10 - 3*(1020*m2^3 - 545*m3^2 + 1170*m2*m4 - 12*m6)*n_x^9 - 6*(390*m2^3 + 25*m3^2 + 28*m6)*n_x^8 + 72*(15*m2^3 - 5*m3^2 + 10*m2*m4 + m6)*n_x^7)*n_y^3 - 3*(25*m3^2*n_x^13 - (225*m2^3 + 120*m3^2 - 60*m2*m4 + 4*m6)*n_x^12 + (1005*m2^3 + 60*m3^2 + 30*m2*m4 + 4*m6)*n_x^11 - 2*(600*m2^3 - 85*m3^2 + 135*m2*m4 - 2*m6)*n_x^10 + (360*m2^3 - 195*m3^2 + 240*m2*m4 - 4*m6)*n_x^9 + 60*(m2^3 + m3^2 - m2*m4)*n_x^8)*n_y^2 + 15*(m3^2*n_x^13 - (6*m2^3 + m3^2)*n_x^12 + 12*m2^3*n_x^9 + (42*m2^3 - m3^2)*n_x^11 - (48*m2^3 - m3^2)*n_x^10)*n_y)/(n_x^7*n_y^15 + (8*n_x^8 - 45*n_x^7 + 25*n_x^6 - 23*n_x^5 + 15*n_x^4 - 5*n_x^3)*n_y^14 + (28*n_x^9 - 315*n_x^8 + 1041*n_x^7 - 1035*n_x^6 + 968*n_x^5 - 582*n_x^4 + 250*n_x^3 - 95*n_x^2 + 15*n_x)*n_y^13 + (56*n_x^10 - 945*n_x^9 + 5746*n_x^8 - 15009*n_x^7 + 18194*n_x^6 - 17382*n_x^5 + 11102*n_x^4 - 4984*n_x^3 + 1765*n_x^2 - 360*n_x + 60)*n_y^12 + 60*n_x^12 + (70*n_x^11 - 1575*n_x^10 + 14015*n_x^9 - 61245*n_x^8 + 138114*n_x^7 - 174283*n_x^6 + 163238*n_x^5 - 107571*n_x^4 + 52507*n_x^3 - 20705*n_x^2 + 5460*n_x - 780)*n_y^11 - 780*n_x^11 + (56*n_x^12 - 1575*n_x^11 + 18570*n_x^10 - 115728*n_x^9 + 403823*n_x^8 - 803772*n_x^7 + 969776*n_x^6 - 834367*n_x^5 + 498284*n_x^4 - 209069*n_x^3 + 65785*n_x^2 - 12810*n_x + 780)*n_y^10 + 780*n_x^10 + (28*n_x^13 - 945*n_x^12 + 14015*n_x^11 - 115728*n_x^10 + 565900*n_x^9 - 1656392*n_x^8 + 2913840*n_x^7 - 3198552*n_x^6 + 2405947*n_x^5 - 1196804*n_x^4 + 378693*n_x^3 - 82370*n_x^2 + 10845*n_x + 660)*n_y^9 + 660*n_x^9 + (8*n_x^14 - 315*n_x^13 + 5746*n_x^12 - 61245*n_x^11 + 403823*n_x^10 - 1656392*n_x^9 + 4192900*n_x^8 - 6526559*n_x^7 + 6365599*n_x^6 - 4065108*n_x^5 + 1560742*n_x^4 - 280282*n_x^3 + 8290*n_x^2 + 1290*n_x - 840)*n_y^8 - 840*n_x^8 + (n_x^15 - 45*n_x^14 + 1041*n_x^13 - 15009*n_x^12 + 138114*n_x^11 - 803772*n_x^10 + 2913840*n_x^9 - 6526559*n_x^8 + 9021718*n_x^7 - 7773202*n_x^6 + 4204679*n_x^5 - 1200142*n_x^4 + 38980*n_x^3 + 54690*n_x^2 - 6960*n_x + 120)*n_y^7 + 120*n_x^7 + (25*n_x^14 - 1035*n_x^13 + 18194*n_x^12 - 174283*n_x^11 + 969776*n_x^10 - 3198552*n_x^9 + 6365599*n_x^8 - 7773202*n_x^7 + 5924490*n_x^6 - 2796336*n_x^5 + 645586*n_x^4 + 19470*n_x^3 - 30120*n_x^2 + 2520*n_x)*n_y^6 - (23*n_x^14 - 968*n_x^13 + 17382*n_x^12 - 163238*n_x^11 + 834367*n_x^10 - 2405947*n_x^9 + 4065108*n_x^8 - 4204679*n_x^7 + 2796336*n_x^6 - 1209662*n_x^5 + 272430*n_x^4 - 7920*n_x^3 - 2760*n_x^2)*n_y^5 + (15*n_x^14 - 582*n_x^13 + 11102*n_x^12 - 107571*n_x^11 + 498284*n_x^10 - 1196804*n_x^9 + 1560742*n_x^8 - 1200142*n_x^7 + 645586*n_x^6 - 272430*n_x^5 + 63840*n_x^4 - 3480*n_x^3)*n_y^4 - (5*n_x^14 - 250*n_x^13 + 4984*n_x^12 - 52507*n_x^11 + 209069*n_x^10 - 378693*n_x^9 + 280282*n_x^8 - 38980*n_x^7 - 19470*n_x^6 - 7920*n_x^5 + 3480*n_x^4)*n_y^3 - 5*(19*n_x^13 - 353*n_x^12 + 4141*n_x^11 - 13157*n_x^10 + 16474*n_x^9 - 1658*n_x^8 - 10938*n_x^7 + 6024*n_x^6 - 552*n_x^5)*n_y^2 + 15*(n_x^13 - 24*n_x^12 + 364*n_x^11 - 854*n_x^10 + 723*n_x^9 + 86*n_x^8 - 464*n_x^7 + 168*n_x^6)*n_y)
}
