% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textAnalysis.R
\name{corpusFromGraph}
\alias{corpusFromGraph}
\title{Create a text corpus from graph text attribute data}
\usage{
corpusFromGraph(
  g = NULL,
  txt_attr = NULL,
  type = "vertex",
  iconv = FALSE,
  html_decode = TRUE,
  rm_url = TRUE,
  rm_num = TRUE,
  rm_punct = TRUE,
  rm_twit_hashtags = FALSE,
  rm_twit_users = FALSE,
  sw_kind = "SMART",
  rm_words = NULL,
  stem = FALSE
)
}
\arguments{
\item{g}{an \pkg{igraph} graph object.}

\item{txt_attr}{Character string. Name of graph text attribute. Default is \code{NULL}.}

\item{type}{Character string. Graph attribute type. Default is \code{"vertex"}.}

\item{iconv}{Logical. Use the \code{iconv} function to attempt UTF8 conversion. Default is \code{FALSE}.}

\item{html_decode}{Logical. HTML decode text. Default is \code{TRUE}.}

\item{rm_url}{Logical. Remove URL's. Default is \code{TRUE}.}

\item{rm_num}{Logical. Remove numbers. Default is \code{TRUE}.}

\item{rm_punct}{Logical. Remove punctuation. Default is \code{TRUE}.}

\item{rm_twit_hashtags}{Logical. Remove twitter hashtags. Default is \code{FALSE}.}

\item{rm_twit_users}{Logical. Remove twitter user names. Default is \code{FALSE}.}

\item{sw_kind}{Character string. Stopword dictionary. Refer \code{stopwords} \code{kind} parameter.
Default is \code{"SMART"}.}

\item{rm_words}{Character vector. User defined stopwords. Default is \code{NULL}.}

\item{stem}{Logical. Apply word stemming. Default is \code{FALSE}.}
}
\value{
A \pkg{tm} text corpus object.
}
\description{
This function creates a text corpus from node or edge text attribute data in an igraph.
}
