#' Intubation time data from a simulation of a neonatal resuscitation
#'
#' Time data from a high-fidelity simulation experiment of a neonatal resuscitation
#' with 37 midwife students. The simulation was video recorded and actions 
#' required in the intubation process were tagged. This dataset is the execution
#' time (in seconds) of each action performed by the students.
#'
#' @docType data
#'
#' @usage data(intubation)
#'
#' @format A data frame with 37 rows and 7 variables:
#' \describe{
#'   \item{id}{Midwife students ID.}
#'   \item{deci_intub}{Time (in s) when the student decides to intubate the newborn.}
#'   \item{stop_ventil}{Time (in s) when the student stops the mask ventilation of the newborn.}
#'   \item{blade_in}{Time (in s) when the student inserts the laryngoscope blade in the newborn mouth.}
#'   \item{insert_tube}{Time (in s) when the student inserts the endotracheal tube.}
#'   \item{blade_out}{Time (in s) when the student removes the laryngoscope blade out of the newborn mouth.}
#'   \item{restart_ventil}{Time (in s) when the student restarts to ventilate the newborn through the tube.}
#' }
#'
#' @keywords datasets
#'
#' @references Garnier EM, Fouret N, Descoins M (2019) ViSiElse: An innovative 
#' R-package to visualize raw behavioral data over time.
#'  PeerJ Preprints 10.7287/peerj.preprints.27665v2
#' ([PeerJ](https://doi.org/10.7287/peerj.preprints.27665v2))
#'
#' @examples
#' data(intubation)
#' head(intubation)
"intubation"
