% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePosterior.R
\name{computePosterior}
\alias{computePosterior}
\alias{computePosterior.familyPrior}
\alias{computePosterior.familyPrior_laplace}
\title{Internal function: Compute posterior mean and variance of normal location problem}
\usage{
computePosterior(object, ...)

\method{computePosterior}{familyPrior}(object, x, ...)

\method{computePosterior}{familyPrior_laplace}(object, x, ...)
}
\arguments{
\item{object}{Object of class \code{"\link[WALS]{familyPrior}"}, e.g. from
\code{\link[WALS]{weibull}}, should contain all necessary parameters needed
for the posterior.}

\item{...}{Further arguments passed to methods.}

\item{x}{vector. Observed values, i.e. in WALS these are the regression
coefficients of the transformed regressor Z2 standardized by the standard
deviation: \eqn{\gamma_{2u} / s}.}
}
\description{
Computes the posterior mean and variance of the normal location problem with
fixed variance to 1, i.e. \eqn{x | \gamma \sim N(\gamma, 1)}.
The priors for \eqn{\gamma} are either \code{\link[WALS]{weibull}},
\code{\link[WALS]{subbotin}} or \code{\link[WALS]{laplace}}. Their properties
are briefly discussed in \insertCite{magnus2016wals;textual}{WALS}.
Default method of computePosterior uses numerical integration. This is used
for the \code{\link[WALS]{weibull}} and \code{\link[WALS]{subbotin}} priors.
For the \code{\link[WALS]{laplace}} prior closed form expressions exist for the integrals.
In the original MATLAB code, the Gauss-Kronrod quadrature was used for
numerical integration. Here we use the default \code{\link[stats]{integrate}} which
combines Gauss-Kronrod with Wynn's Epsilon algorithm for extrapolation.
}
\details{
See section "Numerical integration in Bayesian estimation step"
in the appendix of \insertCite{huynhwals;textual}{WALS} for details.

\code{computePosterior.familyPrior_laplace()} is the specialized method for the
S3 class \code{"\link[WALS]{familyPrior_laplace}"} and computes the posterior
first and second moments of the normal location problem with a Laplace prior
using the analytical formula (without numerical integration).
For more details, see \insertCite{deluca2020laplace;textual}{WALS} and the
original code of Magnus and De Luca.
}
\references{
\insertAllCited{}

Original MATLAB code on Jan Magnus' website.
\url{https://www.janmagnus.nl/items/WALS.pdf}
}
