% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsNB.R
\name{controlNB}
\alias{controlNB}
\title{Control function for initial NB fit}
\usage{
controlNB(
  start = list(mu = NULL, logTheta = NULL),
  method = "BFGS",
  controlOptim = list(maxit = 100),
  initThetaMASS = FALSE,
  initMASS = TRUE,
  restricted = FALSE,
  eps = .Machine$double.eps^0.25,
  epsilonMASS = 1e-08
)
}
\arguments{
\item{start}{Optional starting values for \code{\link[WALS]{fitNB2}}. Only used if
\code{initMASS = FALSE}.}

\item{method}{Optimization method used in \code{\link[stats]{optim}}. Only used if
\code{initMASS = FALSE}.}

\item{controlOptim}{List with parameters controlling optimization process of
\code{\link[stats]{optim}}. Only used if \code{initMASS = FALSE}.}

\item{initThetaMASS}{If TRUE, then initial \eqn{\log{\theta}} of
\code{\link[WALS]{fitNB2}} is estimated using \code{\link[MASS]{theta.ml}}
(ML-estimation over 1 variable) based on regression coefficients from
Poisson regression. If \code{FALSE}, then initial \eqn{\log{\theta}} = 0 is used.}

\item{initMASS}{If \code{TRUE} (default), then initial fit in \code{\link[WALS]{fitNB2}}
is estimated via \code{\link[MASS]{glm.nb}} and \code{initThetaMASS} is ignored.
If \code{FALSE}, then the initial fit is estimated by minimizing the
log-likelihood using \code{\link[stats]{optim}}.}

\item{restricted}{If \code{TRUE}, then initial fit in \code{\link[WALS]{fitNB2}}
only considers the focus regressors. By default \code{FALSE}, then the unrestricted
model is estimated in \code{\link[WALS]{fitNB2}} (i.e. all regressors).}

\item{eps}{Controls argument \code{eps} in \code{\link[WALS]{fitNB2}} for generating
starting value for \code{logTheta} (\eqn{\log{\theta}}) via \code{\link[MASS]{theta.ml}}.}

\item{epsilonMASS}{Sets epsilon in control argument of \code{\link[MASS]{glm.nb}}.}
}
\value{
Returns a list containing the parameters specified in the arguments
to be used in \code{\link[WALS]{walsNB}} (and \code{\link[WALS]{walsNBfitIterate}}).
}
\description{
Defines controllable parameters of initial NB fit in \code{\link[WALS]{walsNB}}.
}
\examples{
data("NMES1988", package = "AER")
walsNB(visits ~ health + chronic + age + gender | I((age^2)/10) +
       married + region, data = NMES1988, prior = weibull(),
       controlInitNB = controlNB(initMASS = FALSE, restricted = TRUE))

}
\seealso{
\link{walsNB}, \link{walsNBfitIterate}.
}
