#' Inversion of LAI from look up table generated by WCM
#'
#' @param img raster object
#' @param lookuptable Look up table simulated from 'wcm_sim' function
#'
#' @return a raster object (pixel value represents LAI)
#' @export
#' @examples
#' radar <- raster::raster(ncol=10, nrow=10)
#' val <- seq(-12,-7, length.out=100)
#' radar[] <- val
#' A= -9.596695
#' B= -0.005331
#' C= -11.758309
#' D=  0.011344
#' lut <- lut_wcm(LAI=seq(1,6,0.1), SM=seq(0,.6,.01),coeff=c(A,B,C,D))
#'example(out_lai <- lai_inversion_lut(img = radar,lookuptable = lut))
lai_inversion_lut <- function(img,lookuptable){
  lut <- deparse(substitute(lookuptable))
  search_lai <- function(x){
    search_col_data <- lookuptable$sig
    diff <- c()
    for (i in 1:NROW(search_col_data)){
      diff[i]<- abs(search_col_data[i]-x)
    }
    idx <- which.min(diff)
    min_diff <- diff[idx]
    matchedRowValues <- lookuptable[idx,]
    y <- matchedRowValues$LAI
    return(y)
  }
  #####
  raster::beginCluster()
  output <- raster::clusterR(img, raster::calc, args=list(fun=search_lai), export =lut)
  raster::endCluster()
  return(output)
}
