% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xicor.R
\name{xicor}
\alias{xicor}
\alias{xi}
\title{Compute the cross rank increment correlation coefficient xi.}
\usage{
xicor(
  x,
  y = NULL,
  pvalue = FALSE,
  ties = TRUE,
  method = "asymptotic",
  nperm = 1000,
  factor = FALSE
)
}
\arguments{
\item{x}{Vector of numeric values in the first coordinate.}

\item{y}{Vector of numeric values in the second coordinate.}

\item{pvalue}{Whether or not to return the p-value of rejecting
independence, if TRUE the function also returns the standard deviation of
xi.}

\item{ties}{Do we need to handle ties? If ties=TRUE the algorithm assumes
that the data has ties and employs the more elaborated theory for
calculating s.d. and P-value. Otherwise, it uses the simpler theory. There
is no harm in putting ties = TRUE even if there are no ties.}

\item{method}{If method = "asymptotic" the function returns P-values
computed by the asymptotic theory. If method = "permutation", a permutation
test with nperm permutations is employed to estimate the P-value. Usually,
there is no need for the permutation test. The asymptotic theory is good
enough.}

\item{nperm}{In the case of a permutation test, \code{nperm} is the number
of permutations to do.}

\item{factor}{Whether to transform integers into factors, the default is to
leave them alone.}
}
\value{
In the case pvalue=FALSE, function returns the value of the xi
coefficient, if the input is a matrix, a matrix of coefficients is returned.
In the case pvalue=TRUE is chosen, the function returns a list:
\describe{\item{xi}{The
value of the xi coefficient.}
\item{sd}{The standard deviation.}
\item{pval}{The test p-value.}
}
}
\description{
This function computes the xi coefficient between two vectors x and y,
possibly all coefficients for a matrix. If only one coefficient is computed
it can be used to test independence using a Monte Carlo permutation test or
through an asymptotic approximation test.
}
\note{
Dataset peas no longer available in psych, we are now using psychTools.

This version does not use a seed as argument, if reproducibility is an issue, set a seed before calling the function.
}
\examples{

##---- Should be DIRECTLY executable !! ----
library("psychTools")
data(peas)
# Visualize       the peas data
library(ggplot2)
ggplot(peas,aes(parent,child)) +
geom_count() + scale_radius(range=c(0,5)) +
       xlim(c(13.5,24))+ylim(c(13.5,24))+       coord_fixed() +
       theme(legend.position="bottom")
# Compute one of the coefficients
xicor(peas$parent,peas$child,pvalue=TRUE)
xicor(peas$child,peas$parent)
# Compute all the coefficients
xicor(peas)

}
\references{
Chatterjee, S. (2020) <arXiv:1909.10140>.
}
\seealso{
dcov
}
\author{
Sourav Chatterjee, Susan Holmes
}
\keyword{~htest}
\keyword{~methods}
