% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{weighted_kulczynski_second}
\alias{weighted_kulczynski_second}
\title{Weighted Kulczynski distance}
\usage{
weighted_kulczynski_second(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The weighted Kulczynski distance between \code{x} and \code{y}. The
  distance is undefined if the sum of \code{x} or the sum of \code{y} is
  zero, in which case we return \code{NaN}.
}
\description{
The quantitative version of the second Kulczynski index
}
\details{
The quantitative version of the second Kulczynski index is defined as
\deqn{
  d(x, y) = 1 - \frac{1}{2} \left (
    \frac{\sum_i \min{(x_i, y_i)}}{\sum_i x_i} +
    \frac{\sum_i \min{(x_i, y_i)}}{\sum_i y_i}
  \right ).
}
Relation of \code{weighted_kulczynski_second()} to other definitions:
\itemize{
  \item Equivalent to \code{vegdist()} with \code{method = "kulczynski"}.
  \item Equivalent to \code{structkulczynski} in Mothur.
  \item Equivalent to \eqn{1 - S_{18}} in Legendre & Legendre.
}
}
