% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASDA.R
\name{print.ASDA}
\alias{print.ASDA}
\title{Print method for ASDA object}
\usage{
\method{print}{ASDA}(x, digits = max(3, getOption("digits") - 3), numshow = 5, ...)
}
\arguments{
\item{x}{Object of class ASDA. This object is returned from the function \code{\link{ASDA}}.}

\item{digits}{Number of digits to show in printed numbers.}

\item{numshow}{Number of best ranked variables w.r.t. to their absolute coefficients.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An invisible copy of \code{x}.
}
\description{
Prints a summary of the output from the \code{\link{ASDA}} function. The
output summarizes the discriminant analysis in human readable format.
}
\examples{
    # Prepare training and test set
    train <- c(1:40,51:90,101:140)
    Xtrain <- iris[train,1:4]
    nX <- normalize(Xtrain)
    Xtrain <- nX$Xc
    Ytrain <- iris[train,5]
    Xtest <- iris[-train,1:4]
    Xtest <- normalizetest(Xtest,nX)
    Ytest <- iris[-train,5]

    # Run the algorithm
    resDef <- ASDA(Xtrain,Ytrain)

    # Print
    print(resDef)
}
\seealso{
\code{\link{ASDA}}, \code{\link{predict.ASDA}} and \code{\link{SDAD}}
}
