% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media_getPathToExistingFile.R
\name{media_getPathToExistingFile}
\alias{media_getPathToExistingFile}
\title{Gets the path of a media file for a transcript}
\usage{
media_getPathToExistingFile(
  t,
  filterMediaFile = c(".*\\\\.(mp4|mov)", ".*\\\\.(aiff|aif|wav)", ".*\\\\.mp3")
)
}
\arguments{
\item{t}{transcript object; transcript for which you want to get the media path.}

\item{filterMediaFile}{Vector of character strings; Each element of the vector is a regular expression. Expressions will be checked consecutively. The first match with an existing media file will be used for playing. The default checking order is video > uncompressed audio > compressed audio.}
}
\value{
Character string; path to a media file, or \code{NULL} if no existing media file has been found.
}
\description{
Gets the path of a media file for a transcript
}
\examples{
library(act)

# Please be aware that that the example corpus that comes with the package
# does NOT contain media files. Please download the entire example corpus
# with media files if you want to use this function reasonably.

# You can access the media files linked to a transcript directly using
# the object properties.
examplecorpus@transcripts[["SYNC_rotar_y_flexionar"]]@media.path

# Get only media files of a certain type, e.g. a wav file, and return only the first match:
act::media_getPathToExistingFile(examplecorpus@transcripts[["SYNC_rotar_y_flexionar"]],
 filterMediaFile=".*\\\\.wav")
}
\seealso{
\link{media_assign}, \link{media_delete}
}
