% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trait_axis}
\alias{trait_axis}
\title{Create a Data Frame of Trait Data for Invasion Analysis}
\usage{
trait_axis(
  historical = NULL,
  stagebased = NULL,
  agebased = NULL,
  stageframe = NULL,
  stage3 = NULL,
  stage2 = NULL,
  stage1 = NULL,
  age3 = NULL,
  age2 = NULL,
  eststage3 = NULL,
  eststage2 = NULL,
  eststage1 = NULL,
  estage3 = NULL,
  estage2 = NULL,
  givenrate = NULL,
  offset = NULL,
  multiplier = NULL,
  type = NULL,
  type_t12 = NULL,
  surv_dev = NULL,
  obs_dev = NULL,
  size_dev = NULL,
  sizeb_dev = NULL,
  sizec_dev = NULL,
  repst_dev = NULL,
  fec_dev = NULL,
  jsurv_dev = NULL,
  jobs_dev = NULL,
  jsize_dev = NULL,
  jsizeb_dev = NULL,
  jsizec_dev = NULL,
  jrepst_dev = NULL,
  jmatst_dev = NULL
)
}
\arguments{
\item{historical}{A single logical value indicating whether the MPMs
intended will be historical or ahistorical. Defaults to \code{TRUE}.}

\item{stagebased}{A single logical value indicating whether the MPM will be
stage-based or age-by-stage. Defaults to \code{TRUE}.}

\item{agebased}{A single logical value indicating whether the MPM will be
age-based or age-by-stage. Defaults to \code{FALSE}.}

\item{stageframe}{The stageframe used to produce the MPM. Required if
producing any stage-based or age-by-stage MPM. Must be omitted for purely
age-based MPMs.}

\item{stage3}{String vector of stage names in occasion \emph{t}+1 in the
transition to be affected. Abbreviations for groups of stages are also
usable (see \code{Notes}). Required in all stage-based and age-by-stage
MPMs.}

\item{stage2}{String vector of stage names in occasion \emph{t} in the
transition to be affected. Abbreviations for groups of stages are also
usable (see \code{Notes}). Required in all stage-based and age-by-stage
MPMs.}

\item{stage1}{String vector of stage names in occasion \emph{t}-1 in the
transition to be affected. Only needed if a historical matrix is to be
produced. Abbreviations for groups of stages are also usable (see
\code{Notes}). Required for historical stage-based MPMs.}

\item{age3}{An integer vector of the ages in occasion \emph{t}+1 to use in
transitions to be affected. Required for all age- and age-by-stage MPMs.}

\item{age2}{An integer vector of the ages in occasion \emph{t} to use in
transitions to be affected. Required for all age- and age-by-stage MPMs.}

\item{eststage3}{String vector of stage names to replace \code{stage3} in a
proxy transition. Only needed if a transition will be replaced by another
estimated transition, and only in stage-based and age-by-stage MPMs.}

\item{eststage2}{String vector of stage names to replace \code{stage2} in a
proxy transition. Only needed if a transition will be replaced by another
estimated transition, and only in stage-based and age-by-stage MPMs.}

\item{eststage1}{String vector of stage names to replace \code{stage1} in a
proxy historical transition. Only needed if a transition will be replaced by
another estimated transition, and the matrix to be estimated is historical
and stage-based. Stage \code{NotAlive} is also possible for raw hMPMs as a
means of handling the prior stage for individuals entering the population in
occasion \emph{t}.}

\item{estage3}{Integer vector of age at time \emph{t}+1 to replace
\code{age3} in a proxy transition. Only needed if a transition will be
replaced by another estimated transition, and only in age-based and
age-by-stage MPMs.}

\item{estage2}{Integer vector of age at time \emph{t} to replace \code{age2}
in a proxy transition. Only needed if a transition will be replaced by
another estimated transition, and only in age-based and age-by-stage MPMs.}

\item{givenrate}{A numeric vector of fixed rates or probabilities to replace
for the transition described by \code{stage3}, \code{stage2}, \code{stage1},
and/or \code{age2}.}

\item{offset}{A numeric vector of fixed numeric values to add to the
transitions described by \code{stage3}, \code{stage2}, \code{stage1}, and/or
\code{age2}.}

\item{multiplier}{A numeric vector of multipliers for the transition
described by \code{stage3}, \code{stage2}, \code{stage1}, and/or
\code{age2}, or for the proxy transitions described by \code{eststage3},
\code{eststage2}, \code{eststage1}, and/or \code{estage2}. Defaults to
\code{1}.}

\item{type}{Integer vector denoting the kind of transition between occasions
\emph{t} and \emph{t}+1 to be replaced. This should be entered as \code{1},
\code{S}, or \code{s} for the replacement of a survival transition;
\code{2}, \code{F}, or \code{f} for the replacement of a fecundity
transition; or \code{3}, \code{R}, or \code{r} for a fecundity set value /
general multiplier. If empty or not provided, then defaults to \code{1} for
survival transition.}

\item{type_t12}{An optional integer vector denoting the kind of transition
between occasions \emph{t}-1 and \emph{t}. Only necessary if a historical
MPM in deVries format is desired. This should be entered as \code{1},
\code{S}, or \code{s} for a survival transition; or \code{2}, \code{F}, or
\code{f} for a fecundity transitions. Defaults to \code{1} for survival
transition, with impacts only on the construction of deVries-format hMPMs.}

\item{surv_dev}{An optional vector of numeric deviations to the y-intercept
of the survival model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{obs_dev}{An optional vector of numeric deviations to the y-intercept
of the observation model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{size_dev}{An optional vector of numeric deviations to the y-intercept
of the primary size model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{sizeb_dev}{An optional vector of numeric deviations to the y-intercept
of the secondary size model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{sizec_dev}{An optional vector of numeric deviations to the y-intercept
of the tertiary size model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{repst_dev}{An optional vector of numeric deviations to the y-intercept
of the reproduction model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{fec_dev}{An optional vector of numeric deviations to the y-intercept
of the fecundity model used in function-based MPM creation. Defaults to
\code{NA} for all values.}

\item{jsurv_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile survival model used in function-based MPM creation. Defaults
to \code{NA} for all values.}

\item{jobs_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile observation model used in function-based MPM creation.
Defaults to \code{NA} for all values.}

\item{jsize_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile primary size model used in function-based MPM creation.
Defaults to \code{NA} for all values.}

\item{jsizeb_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile secondary size model used in function-based MPM creation.
Defaults to \code{NA} for all values.}

\item{jsizec_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile tertiary size model used in function-based MPM creation.
Defaults to \code{NA} for all values.}

\item{jrepst_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile reproduction model used in function-based MPM creation.
Defaults to \code{NA} for all values.}

\item{jmatst_dev}{An optional vector of numeric deviations to the y-intercept
of the juvenile maturity model used in function-based MPM creation.
Defaults to \code{NA} for all values.}
}
\value{
A data frame of class \code{adaptAxis}. This object can be used as
input in function \code{invade3()}.

Variables in this object include the following:
\item{variant}{Denotes each variant in order, with each row corresponding to
a novel variant.}
\item{stage3}{Stage at occasion \emph{t}+1 in the transition to be
replaced.}
\item{stage2}{Stage at occasion \emph{t} in the transition to be replaced.}
\item{stage1}{Stage at occasion \emph{t}-1 in the transition to be
replaced.}
\item{age3}{Age at occasion \emph{t}+1 in the transition to be replaced.}
\item{age2}{Age at occasion \emph{t} in the transition to be replaced.}
\item{eststage3}{Stage at occasion \emph{t}+1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{eststage2}{Stage at occasion \emph{t} in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{eststage1}{Stage at occasion \emph{t}-1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{estage3}{Age at occasion \emph{t}+1 in the transition to replace the
transition designated by \code{age3}.}
\item{estage2}{Age at occasion \emph{t} in the transition to replace the
transition designated by \code{age2}.}
\item{givenrate}{A constant to be used as the value of the transition.}
\item{offset}{A constant value to be added to the transition or proxy
transition.}
\item{multiplier}{A multiplier for proxy transitions or for fecundity.}
\item{convtype}{Designates whether the transition from occasion \emph{t} to
occasion \emph{t}+1 is a survival transition probability (1), a fecundity
rate (2), or a fecundity multiplier (3).}
\item{convtype_t12}{Designates whether the transition from occasion
\emph{t}-1 to occasion \emph{t} is a survival transition probability (1), a
fecundity rate (2).}
\item{surv_dev}{Numeric deviations to the y-intercept of the vital rate
model of survival.}
\item{obs_dev}{Numeric deviations to the y-intercept of the vital rate model
of observation.}
\item{size_dev}{Numeric deviations to the y-intercept of the vital rate
model of primary size.}
\item{sizeb_dev}{Numeric deviations to the y-intercept of the vital rate
model of secondary size.}
\item{sizec_dev}{Numeric deviations to the y-intercept of the vital rate
model of tertiary size.}
\item{repst_dev}{Numeric deviations to the y-intercept of the vital rate
model of reproduction.}
\item{fec_dev}{Numeric deviations to the y-intercept of the vital rate model
of fecundity.}
\item{jsurv_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile survival.}
\item{jobs_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile observation.}
\item{jsize_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile primary size.}
\item{jsizeb_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile secondary size.}
\item{jsizec_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile tertiary size.}
\item{jrepst_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile reproduction.}
\item{jmatst_dev}{Numeric deviations to the y-intercept of the vital rate
model of juvenile maturity.}
}
\description{
Function \code{trait_axis()} provides all necessary data for invasion
analysis. It lists the specific variations to MPMs for each variant run.
Variants can be given via overwritten matrix elements, proxy matrix
elements, additive offsets on matrix elements, matrix element multipliers,
and additive offsets to y-intercepts in vital rate models.
}
\section{Notes}{

Negative values are not allowed in \code{givenrate} and \code{multiplier}
input, but are allowed in \code{offset}, if values are to be subtracted from
specific estimated transitions. Stage entries should not be used for purely
age-based MPMs, and age entries should not be used for purely stage-based
MPMs.

Entries in \code{stage3}, \code{stage2}, and \code{stage1} can include
abbreviations for groups of stages. Use \code{rep} if all reproductive
stages are to be used, \code{nrep} if all mature but non-reproductive stages
are to be used, \code{mat} if all mature stages are to be used, \code{immat}
if all immature stages are to be used, \code{prop} if all propagule stages
are to be used, \code{npr} if all non-propagule stages are to be used,
\code{obs} if all observable stages are to be used, \code{nobs} if all
unobservable stages are to be used, and leave empty or use \code{all} if all
stages in stageframe are to be used. Also use \code{groupX} to denote all
stages in group X (e.g. \code{group1} will use all stages in the respective
stageframe's group 1).

Type 3 conversions are referred to as fecundity set values, or general
fecundity multipliers. These set the transitions to be used as fecundity
transitions. Transitions set here will be interpreted as being generally
reproductive, meaning that the from and to stages will be used to determine
the general fecundity transitions to incorporate into stage-based MPMs,
while the age portion of the input will be used to incorporate the actual
multiplier(s) specified. If only stage transitions at certain ages are
expected to be the sole contributors to fecundity, then type 2 conversions
should also be included in the supplement (Type 1 and 2 conversions can be
purely age-specific, and do not set reproductive transitions in MPM
creation). For example, if all stage 2 to stage 3 transitions above age 2
yield fecundity, then stage 2 to stage 3 can be set to
\code{multiplier = 1.0} with \code{convtype = 3}, and the same transition
for \code{age2 = c(1, 2)} can be set to \code{multiplier = c(0, 0)}.

Several operations may be included per transition. Operations on the same
row of the resulting data frame are generally handled with given rate
substitutions first, then with proxy transitions, then by additive offsets,
and finally by multipliers. This order can be manipulated by ordering
operations across rows, with higher numbered rows in the data frame being
performed later.
}

\examples{
library(lefko3)

data(cypa_data)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypa_data, noyears = 18, firstyear = 1994,
  individcol = "plant_id", blocksize = 2, sizeacol = "Inf.94",
  sizebcol = "Veg.94", repstracol = "Inf.94", fecacol = "Inf.94",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypa_ta <- trait_axis(stageframe = cypframe_raw,
  stage3 = c("P1", "P1", "P1", NA, NA, NA),
  stage2 = c("rep", "rep", "rep", NA, NA, NA),
  multiplier = c(0.5, 2.0, 10., NA, NA, NA), type = c(2, 2, 2, NA, NA, NA),
  obs_dev = c(NA, NA, NA, 0.5, 2.0, 50), fec_dev = c(NA, NA, NA, -1000, 0, 1000))

}
\seealso{
\code{\link{ta_skeleton}()}
}
