% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adass_functions.R
\name{adass.fr}
\alias{adass.fr}
\title{Adaptive smoothing spline estimator for the function-on-function linear regression model}
\usage{
adass.fr(
  Y_fd,
  X_fd,
  basis_s,
  basis_t,
  beta_ders = NULL,
  beta_dert = NULL,
  grid_eval_ders = NULL,
  grid_eval_dert = NULL,
  tun_par = c(lambda_s = 10^4, lambda_t = 10^4, delta_s = 0, gamma_s = 1, delta_t = 0,
    delta_t = 1),
  CV = FALSE,
  K = 10,
  X_fd_test = NULL,
  Y_fd_test = NULL
)
}
\arguments{
\item{Y_fd}{An object of class fd corresponding to the response functions.}

\item{X_fd}{An object of class fd corresponding to the covariate functions.}

\item{basis_s}{B-splines basis along the \code{s}-direction of class basisfd.}

\item{basis_t}{B-splines basis along the \code{t}-direction of class basisfd.}

\item{beta_ders}{Initial estimate of the partial derivative of the coefficient function along the \code{s}-direction.
Either a matrix or a class basisfd object. If NULL no adaptive penalty is  used along the \code{s}-direction.}

\item{beta_dert}{Initial estimate of the partial derivative of the coefficient function along the \code{t}-direction.
Either a matrix or a class basisfd object. If NULL no adaptive penalty is used along the \code{t}-direction.}

\item{grid_eval_ders}{Grid of evaluation of the partial derivatives along the \code{s}-direction.}

\item{grid_eval_dert}{Grid of evaluation of the partial derivatives along the \code{t}-direction.}

\item{tun_par}{Vector of tuning parameters.}

\item{CV}{If TRUE the \code{K}-fold cross-validation prediction error is calculated. Default is FALSE.
If \code{X_fd_test} and \code{Y_fd_test} are both provided the prediction error on the test set is calculated in place of the cross-validation prediction error when \code{CV} is TRUE.}

\item{K}{Number of folds. Default is 10.}

\item{X_fd_test}{Test set covariate functions. Default is NULL.}

\item{Y_fd_test}{Test set response functions. Default is NULL.}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{B}: The basis coefficients matrix estimate of the coefficient function.

\item \code{Beta_hat_fd}: The coefficient function estimate of class bifd.

\item \code{alpha}: The intercept function estimate.

\item \code{tun_par}: Vector of tuning parameters.

\item \code{CV}: Estimated prediction error.

\item \code{CV_sd}: Standard error of the estimated prediction error.

\item \code{Y_fd}: The response functions.

\item \code{X_fd}: The covariate functions.
}
}
\description{
The adaptive smoothing spline (AdaSS) estimator for the function-on-function linear regression proposed in Centofanti et al., 2020.
}
\examples{
library(adass)
data<-simulate_data("Scenario HAT",n_obs=100)
X_fd=data$X_fd
Y_fd=data$Y_fd
basis_s <- fda::create.bspline.basis(c(0,1),nbasis = 10,norder = 4)
basis_t <- fda::create.bspline.basis(c(0,1),nbasis = 10,norder = 4)
mod_smooth <-adass.fr(Y_fd,X_fd,basis_s = basis_s,basis_t = basis_t,tun_par=c(10^-6,10^-6,0,0,0,0))
grid_s<-seq(0,1,length.out = 10)
grid_t<-seq(0,1,length.out = 10)
beta_der_eval_s<-fda::eval.bifd(grid_s,grid_t,mod_smooth$Beta_hat_fd,sLfdobj = 2)
beta_der_eval_t<-fda::eval.bifd(grid_s,grid_t,mod_smooth$Beta_hat_fd,tLfdobj = 2)
mod_adass <-adass.fr(Y_fd, X_fd, basis_s = basis_s, basis_t = basis_t,
                     tun_par=c(10^-6,10^-6,0,1,0,1),beta_ders = beta_der_eval_s,
                     beta_dert = beta_der_eval_t,grid_eval_ders=grid_s,grid_eval_dert=grid_t )
}
\references{
Centofanti, F., Lepore, A., Menafoglio, A., Palumbo, B., Vantini, S. (2023).
Adaptive Smoothing Spline Estimator for the Function-on-Function Linear Regression Model.
\emph{Computational Statistics 38(1), 191–216}.
}
\seealso{
\code{\link{adass.fr_eaass}}
}
