% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sedrate_gen_helpers.R
\name{sed_rate_gen_gamma}
\alias{sed_rate_gen_gamma}
\title{sed. rate gen based on gamma distribution}
\usage{
sed_rate_gen_gamma(h, shapes, rates, rule = 1)
}
\arguments{
\item{h}{heights at which sedimentation rate is determined}

\item{shapes}{shape parameters for the gamma distribution}

\item{rates}{rate parameter for the gamma distribution}

\item{rule}{an integer of length 1 or 2, see description for details}
}
\value{
a function factory for usage with \code{sedrate_to_multiadm}
}
\description{
generates a function factory for usage with \code{sedrate_to_multiadm}. At \code{h[i]},
the sedimentation rate is given by a gamma distribution with parameters
\code{shapes[i]} and \code{rates[i]}. Between those values, sedimentation rate is linearly interpolated
Outside of the range of \code{h}, behavior is determined by the argument \code{rule}
which is passed to \code{approxfun}. See there for details.
}
\seealso{
\itemize{
\item \code{\link[=sedrate_to_multiadm]{sedrate_to_multiadm()}} for estimating age-depth models using the outputs
\item \code{\link[=sed_rate_from_matrix]{sed_rate_from_matrix()}} for other means of defining sedimentation rates
\item \code{\link[=sed_rate_gen_from_bounds]{sed_rate_gen_from_bounds()}} for sed. rate generator based on bounds on sedimentation rates.
}
}
