% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_to_time.list.R
\name{strat_to_time.list}
\alias{strat_to_time.list}
\title{transform list from height to time domain}
\usage{
\method{strat_to_time}{list}(obj, x, ...)
}
\arguments{
\item{obj}{a list with one element named "h", which will be interpreted as stratigraphic positions}

\item{x}{an \emph{adm} object}

\item{...}{options passed to \code{get_time}}
}
\value{
a \code{timelist} (inherits from \code{list}). A list with one named element "t" instead of the element "h". This element contains the times of the stratigraphic positions in "h".
}
\description{
Lists are useful to keep data closely associated. This function transforms a list that contains observations
associated with a stratigraphic position (recorded in the element with name "h") into a list where
the observations are associated with time.
}
\examples{
# see vignette("admtools") for an example

}
\seealso{
\code{\link[=time_to_strat.list]{time_to_strat.list()}} for the transformation from time to height domain, \code{\link[=get_time]{get_time()}} for the underlying procedure, \code{\link[=time_to_strat]{time_to_strat()}} for the higher level function
}
