% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquaredDistribution.R
\docType{class}
\name{Pearson2xK-class}
\alias{Pearson2xK-class}
\alias{Pearson2xK}
\alias{get_tau_Pearson2xK}
\title{Pearson's chi-squared test for contingency tables}
\usage{
Pearson2xK(n_groups)

get_tau_Pearson2xK(p_vector)
}
\arguments{
\item{n_groups}{number of groups considered for testing procedure}

\item{p_vector}{vector denoting the event rates per group}
}
\description{
When we test for homogeneity of rates in a k-armed trial with binary endpoints,
the test statistic is chi-squared distributed with \eqn{k-1} degrees of
freedom under the null. Under the alternative, the statistic is chi-squared
distributed with a non-centrality parameter \eqn{\lambda}.
The function \code{get_tau_Pearson2xk} then computes \eqn{\tau}, such that
\eqn{\lambda} is given as \eqn{n \cdot \tau}, where \eqn{n} is the number of
subjects per group. In \code{adoptr}, \eqn{\tau} is used in the same way as \eqn{\theta}
in the case of the normally distributed test statistic.
}
\examples{
pearson <- Pearson2xK(3)


H1 <- PointMassPrior(get_tau_Pearson2xK(c(.3, .25, .4)), 1)

}
