% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\name{Scores}
\alias{Scores}
\alias{expected}
\alias{expected,ConditionalScore-method}
\alias{evaluate}
\alias{evaluate,IntegralScore,TwoStageDesign-method}
\title{Scores}
\usage{
expected(s, data_distribution, prior, ...)

\S4method{expected}{ConditionalScore}(s, data_distribution, prior, label = NA_character_, ...)

evaluate(s, design, ...)

\S4method{evaluate}{IntegralScore,TwoStageDesign}(s, design, optimization = FALSE, subdivisions = 10000L, ...)
}
\arguments{
\item{s}{\code{\link[=Scores]{Score}} object}

\item{data_distribution}{\code{\link{DataDistribution}} object}

\item{prior}{a \code{\link{Prior}} object}

\item{...}{further optional arguments}

\item{label}{object label (string)}

\item{design}{object}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}

\item{subdivisions}{maximal number of subdivisions when evaluating an integral
score using adaptive quadrature (optimization = FALSE)}
}
\value{
No return value. Generic description of class \code{Score}.
}
\description{
In \code{adoptr} scores are used to assess the performance of a design.
This can be done either conditionally on the observed stage-one outcome
or unconditionally.
Consequently, score objects are either of class \code{ConditionalScore} or
\code{UnconditionalScore}.
}
\details{
All scores can be evaluated on a design using the \code{evaluate} method.
Note that \code{evaluate} requires a third argument \code{x1} for
conditional scores (observed stage-one outcome).
Any \code{ConditionalScore} can be converted to a \code{UnconditionalScore}
by forming its expected value using \code{expected}.
The returned unconditional score is of class \code{IntegralScore}.
}
\examples{
design <- TwoStageDesign(
  n1    = 25,
  c1f   = 0,
  c1e   = 2.5,
  n2    = 50,
  c2    = 1.96,
  order = 7L
)
prior <- PointMassPrior(.3, 1)

# conditional
cp <- ConditionalPower(Normal(), prior)
expected(cp, Normal(), prior)
evaluate(cp, design, x1 = .5)

# unconditional
power <- Power(Normal(), prior)
evaluate(power, design)
evaluate(power, design, optimization = TRUE) # use non-adaptive quadrature


}
\seealso{
\code{\link{ConditionalPower}}, \code{\link{ConditionalSampleSize}},
\code{\link{composite}}
}
