% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_test_norm_global.R
\name{adaptive_analysis_norm_global}
\alias{adaptive_analysis_norm_global}
\title{Analyze data according to a globally efficient adaptive design.}
\usage{
adaptive_analysis_norm_global(
  initial_test = 0,
  times = 0,
  stats = 0,
  costs = 0,
  final_analysis = TRUE,
  estimate = TRUE,
  ci_coef = 0.95,
  tol_est = 1e-08,
  input_check = TRUE
)
}
\arguments{
\item{initial_test}{Designate the initial working test generated by \code{work_test_norm_global} function.}

\item{times}{The sequence of times (sample size or information level) at which analyses were conducted.}

\item{stats}{The sequence of test statistics.}

\item{costs}{The sequence of loss required to construct working tests. Specification is optional. Partial specification is allowed, in which non-specification may be represented by \code{0}.}

\item{final_analysis}{If \code{TRUE}, the result input will be regarded as complete (no more data will be obtained) and the significance level will be exhausted. If \code{FALSE}, the current analysis will be regarded as an interim analysis and the significance level will be preserved.}

\item{estimate}{If \code{TRUE}, p-value, median unbiased estimator and upper and lower confidence limits will be calculated.}

\item{ci_coef}{The confidence coefficient. Default is 0.95.}

\item{tol_est}{The precision of the calculated results.}

\item{input_check}{Indicate whether or not the arguments input by user contain invalid values.}
}
\value{
It returns whether or not the result was statistically significant, a p-value and an exact confidence limits.
}
\description{
\code{adaptive_analysis_norm_global} performs an globally efficient adaptive test, 
a Frequentist adaptive test with the specified significance level
with full flexibility.
Normality with known variance is assumed for the test statistic
(more accurately, the test statistic is assumed to follow Brownian motion.)
Null hypothesis is fixed at 0 without loss of generality.
Exact p-value, median unbiased estimate and confidence limits proposed by Gao et al. (2013) can also be calculated.
For detailed illustration, see \code{vignette("adpss_ex")}.
}
\examples{
# Construct an initial working test
# Note: cost_type_1_err will be automatically calculated when 0 is specified.
init_work_test <- work_test_norm_global(min_effect_size = -log(0.65), cost_type_1_err=1683.458)

# Sample size calculation
sample_size_norm_global(
  initial_test = init_work_test,
  effect_size = 11.11 / 20.02, # needs not be MLE
  time = 20.02,
  target_power = 0.75,
  sample_size = TRUE
  )
}
\references{
Kashiwabara, K., Matsuyama, Y. An efficient adaptive design approximating fixed sample size designs. In preparation.
Gao, P., Liu, L., Mehta, C. (2013) Exact inference for adaptive group sequential designs. Stat Med 32: 3991-4005.
}
\seealso{
\code{\link{work_test_norm_global}} and \code{\link{sample_size_norm_global}}.
}
