% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{gt_dim_to_extent}
\alias{gt_dim_to_extent}
\title{Determine extent from eotransform vector and dimension}
\usage{
gt_dim_to_extent(x, dim)
}
\arguments{
\item{x}{geotransform parameters, as per \code{\link[=geo_transform0]{geo_transform0()}}}

\item{dim}{dimensions x,y of grid (ncol,nrow)}
}
\value{
4-element extent c(xmin,xmax,ymin,ymax)
}
\description{
Create the extent (xlim, ylim) from the geotransform and dimensions
of the grid.
}
\details{
The extent is \code{c(xmin, xmax, ymin, ymax)}.
}
\examples{
gt_dim_to_extent(geo_transform0(c(1, -1), c(0, 10)), c(5, 10))
}
